<?php
/**
 * domain-DS
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id$
 * @package service.domain
 */
class PwDomain {
	/**
	 * һ
	 *
	 * @param array $data
	 * @return boolean|number
	 */
	public function replaceDomain(PwDomainDm $dm) {
		if (($r = $dm->beforeUpdate()) instanceof PwError) return $r;
		return $this->_domainDao()->replaceDomain($dm->getData());
	}
	
	/**
	 * type
	 *
	 * @param PwDomainDm $dm
	 * @return boolean|Ambigous <number, boolean, rowCount>
	 */
	public function updateByDomainType(PwDomainDm $dm) {
		if (!$type = $dm->getField('domain_type')) return new PwError('REWRITE:domain_type_null');
		if (($r = $dm->beforeUpdate()) instanceof PwError) return $r;
		return $this->_domainDao()->updateByDomainType($type, $dm->getData());
	}
	
	/**
	 * key
	 *
	 * @param PwDomainDm $dm
	 * @return boolean|Ambigous <number, boolean, rowCount>
	 */
	public function updateByDomainKey(PwDomainDm $dm) {
		if (!$key = $dm->getField('domain_key')) return new PwError('DOMAIN:domain_key_null');
		if (($r = $dm->beforeUpdate()) instanceof PwError) return $r;
		return $this->_domainDao()->updateByDomainKey($key, $dm->getData());
	}
	
	/**
	 * typeɾ
	 *
	 * @param string $type
	 * @return number
	 */
	public function deleteByDomainType($type) {
		if (!$type) return false;
		return $this->_domainDao()->deleteByDomainType($type);
	}
	
	/**
	 * keyɾ
	 *
	 * @param unknown_type $key
	 * @return boolean|Ambigous <number, number>
	 */
	public function deleteByDomainKey($key) {
		if (!$key) return false;
		return $this->_domainDao()->deleteByDomainKey($key);
	}
	
	/**
	 * keyȡ
	 *
	 * @param unknown_type $key
	 * @return Ambigous <multitype:, multitype:unknown , mixed>
	 */
	public function getByDomainKey($key) {
		if (!$key) return array();
		return $this->_domainDao()->getByDomainKey($key);
	}
	
	/**
	 * ͸ȡ
	 *
	 * @param string $domain
	 * @param string $root
	 * @return array
	 */
	public function getByDomainAndRoot($domain, $root) {
		if (!$domain || !$root) return array();
		return $this->_domainDao()->getByDomainAndRoot($domain, $root);
	}
	
	/**
	 * ƻ
	 *
	 * @return array
	 */
	public function getByFirst($first) {
		return $this->_domainDao()->getByFirst($first);
	}
	
	/**
	 * Ͳѯ
	 *
	 * @param string $appType
	 * @return array
	 */
	public function getByType($type) {
		return $this->_domainDao()->getByType($type);
	}
	
	/**
	 * Ͳѯ
	 *
	 * @param string $domain
	 * @param string $type
	 * @return array
	 */
	public function getByDomainAndType($domain, $type) {
		return $this->_domainDao()->getByDomainAndType($domain, $type);
	}
	
	/**
	 * ѯ
	 *
	 * @param string $domain
	 * @param string $type
	 * @return array
	 */
	public function getByDomain($domain) {
		return $this->_domainDao()->getByDomain($domain);
	}
	
	/**
	 * ȡ
	 *
	 */
	public function getAll() {
		return $this->_domainDao()->getAll();
	}
	
	/**
	 * IdͲѯ
	 * 
	 * @param string $type
	 * @param int $id
	 * @return array
	 */
	public function getByTypeAndId($type,$id){
		list($type,$id) = array(trim($type),intval($id));
		if(!$type || $id < 1) return array();
		return $this->_domainDao()->getByTypeAndId($type,$id);
	}
	
	/**
	 * ĳһͺidѯ
	 * 
	 * @param string $type
	 * @param array $ids
	 * @return array
	 */
	public function fetchByTypeAndId($type,$ids){
		$type = trim($type);
		if(!$type || !is_array($ids) || count($ids) < 1) return array();
		return $this->_domainDao()->fetchByTypeAndId($type,$ids);
	}
	
	/**
	 * @return PwDomainDao
	 */
	private function _domainDao() {
		return Wekit::loadDao('domain.dao.PwDomainDao');
	}
}

?>