<?php
Wind::import('SRC:library.base.PwBaseDao');

/**
 * ݸDAO
 *
 * @author jinlong.panjl <jinlong.panjl@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id$
 * @package wind
 */
class PwDraftDao extends PwBaseDao {
	
	protected $_table = 'draft';
	protected $_dataStruct = array('id', 'created_userid', 'title', 'content', 'created_time');
	
	/**
	 * 
	 *
	 * @param array $data
	 * @return bool
	 */
	public function add($data) {
		return $this->_add($data);
	}
	
	/**
	 * ɾ
	 *
	 * @param int $id
	 * @return bool
	 */
	public function delete($id) {
		return $this->_delete($id);
	}
	
	/**
	 * ɾ
	 *
	 * @param array $ids
	 * @return bool
	 */
	public function batchDelete($ids) {
		return $this->_batchDelete($ids);
	}
	
	/**
	 * ޸
	 *
	 * @param int $id
	 * @param array $data
	 * @return bool
	 */
	public function update($id,$data) {
		return $this->_update($id,$data);
	}
	
	/**
	 * ȡһϢ
	 *
	 * @param int $id
	 * @return array
	 */
	public function get($id) {
		return $this->_get($id);
	}
	
	/**
	 * ûͳƲݸ
	 *
	 * @param int $uid
	 * @return int
	 */
	public function countByUid($uid) {
		$sql = $this->_bindTable('SELECT COUNT(*) FROM %s WHERE `created_userid`=?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getValue(array($uid));
	}
	
	/**
	 * ûȡ$num
	 *
	 * @param int $uid
	 * @param int $num
	 * @return array
	 */
	public function getByUid($uid,$num) {
		$sql = $this->_bindSql('SELECT * FROM %s WHERE `created_userid`=? ORDER BY `id` DESC %s ', $this->getTable(), $this->sqlLimit($num));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($uid));
	}
}