<?php

/**
 * ûDS
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwEducation.php 1532 2012-1-1310:41:23 xiaoxiao $
 * @package src.service.user.hooks.experience_education
 */
class PwEducation {

	/** 
	 * ӽ
	 *
	 * @param PwEducationDm $dm
	 * @return PwError|int
	 */
	public function addEducation($dm) {
		if (!$dm instanceof PwEducationDm) return new PwError('USER:education.illegal.datatype');
		if (($result = $dm->beforeAdd()) instanceof PwError) return $result;
		return $this->_getDao()->add($dm->getData());
	}

	/** 
	 * ½
	 *
	 * @param id $id
	 * @param PwEducationDm $dm
	 * @return PwError|boolean|int
	 */
	public function editEducation($id, $dm) {
		$uid = intval($dm->getField('uid'));
		if (($id = intval($id)) < 1 || $uid < 1) return new PwError('USER:education.illegal.request');
		if (!$dm instanceof PwEducationDm) return new PwError('USER:education.illegal.datatype');
		if (($result = $dm->beforeUpdate()) instanceof PwError) return $result;
		$data = $dm->getData();
		unset($data['uid']);
		return $this->_getDao()->update($id, $uid, $data);
	}

	/** 
	 * ɾ
	 *
	 * @param int $id  ID
	 * @param int $uid ӦûID
	 * @return PwError|int
	 */
	public function deleteEducation($id, $uid) {
		if (($id = intval($id)) < 1 || ($uid = intval($uid)) < 1) return new PwError('USER:education.illegal.request');
		return $this->_getDao()->delete($id, $uid);
	}

	/** 
	 * IDû
	 *
	 * @param int $id  ID
	 * @param int $uid ûID 
	 * @return PwError|array
	 */
	public function getEducationById($id, $uid) {
		if (($id = intval($id)) < 1 || ($uid = intval($uid)) < 1) return new PwError('USER:education.illegal.request');
		return $this->_getDao()->get($id, $uid);
	}

	/** 
	 * ûIDɾûĽ
	 *
	 * @param int $uid
	 * @return PwError|int
	 */
	public function deleteEducationByUid($uid) {
		if (($uid = intval($uid)) < 1) return new PwError('USER:education.illegal.uid');
		return $this->_getDao()->deleteByUid($uid);
	}

	/** 
	 * ûIDûб
	 *
	 * @param int $uid
	 * @param int $number ĬΪ10
	 * @param int $start ʼλ
	 * @return array
	 */
	public function getByUid($uid, $number = 10, $start = 0) {
		if (($uid = intval($uid)) < 1) return array();
		return $this->_getDao()->getByUid($uid, $number, $start);
	}

	/** 
	 * ûIDͳƸûӵеĽ
	 *
	 * @param int $uid
	 * @return int
	 */
	public function countByUid($uid) {
		if (($uid = intval($uid)) < 1) return 0;
		return $this->_getDao()->countByUid($uid);
	}

	/** 
	 * ýdao
	 *
	 * @return PwEducationDao
	 */
	private function _getDao() {
		return Wekit::loadDao('SRV:education.dao.PwEducationDao');
	}
}