<?php

/**
 * DAO
 *
 * @author xiaoxia.xu <x_824@sina.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: codetemplates(windframework_docs_zend_8.0).xml 2781 2011-09-22 03:59:17Z yishuo $
 * @package src.service.user.hooks.experience_education.dao
 */
class PwEducationDao extends PwBaseDao {
	protected $_table = 'user_education';
	protected $_dataStruct = array('id', 'uid', 'schoolid', 'degree', 'start_time');
	
	/** 
	 * ӽ
	 *
	 * @param array $data
	 * @return boolean|int
	 */
	public function add($data) {
		if (!($data = $this->_filterStruct($data))) return false;
		$sql = $this->_bindSql('INSERT INTO %s SET %s', $this->getTable(), $this->sqlSingle($data));
		$smt = $this->getConnection()->execute($sql);
		return $this->getConnection()->lastInsertId();
	}
	
	/** 
	 * ½
	 *
	 * @param int $id  ID
	 * @param int $uid ûID
	 * @param array $data
	 * @return boolean|int
	 */
	public function update($id, $uid, $data) {
		if (!($data = $this->_filterStruct($data))) return false;
		$sql = $this->_bindSql('UPDATE %s SET %s WHERE `id` = ? AND `uid` = ?', $this->getTable(), $this->sqlSingle($data));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->update(array($id, $uid));
	}
	
	/** 
	 * ɾ
	 *
	 * @param int $id  ID
	 * @param int $uid ӦûID
	 * @return boolean|int
	 */
	public function delete($id, $uid) {
		$sql = $this->_bindTable('DELETE FROM %s WHERE `id` =? AND `uid` = ?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->update(array($id, $uid));
	}

	/** 
	 * ݽIDȡýϸϢ
	 *
	 * @param int $id ID
	 * @param int $uid ûID
	 * @return array
	 */
	public function get($id, $uid) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE `id` =? AND `uid` = ?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getOne(array($id, $uid));
	}
	
	/** 
	 * ûIDɾû
	 *
	 * @param int $uid
	 * @return boolean|int
	 */
	public function deleteByUid($uid) {
		$sql = $this->_bindTable('DELETE FROM %s WHERE `uid` =?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->update(array($uid));
	}
	
	/** 
	 * ûIDøûĽб
	 *
	 * @param int $uid ûID
	 * @param int $limit 
	 * @param int $start ʼλ
	 * @return array
	 */
	public function getByUid($uid, $limit, $start) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE `uid` =? ORDER BY `start_time` DESC ' . $this->sqlLimit($limit, $start));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($uid), 'id');
	}
	
	/** 
	 * ûIDͳƸûĽ
	 *
	 * @param int $uid
	 * @return int
	 */
	public function countByUid($uid) {
		$sql = $this->_bindTable('SELECT COUNT(*) FROM %s WHERE `uid` =?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getValue(array($uid));
	}
}