<?php

/**
 * 
 *
 * @author xiaoxia.xu <x_824@sina.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: codetemplates(windframework_docs_zend_8.0).xml 2781 2011-09-22 03:59:17Z yishuo $
 * @package src.service.user.hooks.experience_education.srv
 */
class PwEducationHelper {
	
	/**
	 * ؽʱ
	 * 򷵻-100
	 *
	 * @return array
	 */
	public static function getEducationYear() {
		$tyear = Pw::time2str(Pw::getTime(), 'Y');
		return range($tyear, $tyear - 100, -1);
	}
	
	/**
	 * ʱǷǷ
	 *
	 * @param int $year
	 * @return int
	 */
	public static function checkEducationYear($year) {
		$endYear = Pw::time2str(Pw::getTime(), 'Y');
		if ($year > $endYear) {
			$year = $endYear;
		} elseif ($year < ($endYear - 100)) {
			$year = $endYear - 100;
		}
		return $year;
	}
	
	/**
	 * ѧ
	 * 
	 * @param string $select Ҫصkey
	 * @return array
	 */
	public static function getDegrees($selected = '') {
		$degrees = array(
			'8' => 'ʿ',
			'7'	=> 'ʿ',
			'6' => '˶ʿ',
			'5' => 'ѧ',
			'4' => 'ѧר',
			'3'	=> '',
			'2'	=> '',
			'1'	=> 'Сѧ',
		);
		return $selected ? $degrees[$selected] : $degrees;
	}
	
	/**
	 * Ƿ
	 *
	 * @param string $degree
	 * @return boolean
	 */
	public static function checkDegree($degree) {
		return array_key_exists($degree, self::getDegrees());
	}
}