<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * 
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwForum.php 20973 2012-11-22 10:33:45Z jieyin $
 * @package forum
 */

class PwForum {
	
	const FETCH_MAIN = 1;		//ҪϢ
	const FETCH_STATISTICS = 2;	//ͳϢ
	const FETCH_EXTRA = 4;		//չϢ
	const FETCH_ALL = 7;
	
	/**
	 * ȡϢ
	 *
	 * @param int $fid id
	 * @param int $fetchmode  <ȻΪFETCH_*һֻ>
	 * return array
	 */
	public function getForum($fid, $fetchmode = self::FETCH_MAIN) {
		if (empty($fid)) return array();
		return $this->_getDao($fetchmode)->getForum($fid);
	}
	
	/**
	 * ȡϢ
	 *
	 * @param array $fids id
	 * @param int $fetchmode  <ȻΪFETCH_*һֻ>
	 * return array
	 */
	public function fetchForum($fids, $fetchmode = self::FETCH_MAIN) {
		if (empty($fids)) return array();
		return $this->_getDao($fetchmode)->fetchForum($fids);
	}

	/**
	 * ȡаϢ
	 *
	 * @param int $fetchmode  <ȻΪFETCH_*һֻ>
	 * return array
	 */
	public function getForumList($fetchmode = self::FETCH_MAIN) {
		return $this->_getDao($fetchmode)->getForumList();
	}
	
	/**
	 * ȡͨϢ <Ӱ>
	 *
	 * @param int $fetchmode  <ȻΪFETCH_*һֻ>
	 * return array
	 */
	public function getCommonForumList($fetchmode = self::FETCH_MAIN) {
		return $this->_getDao($fetchmode)->getCommonForumList();
	}
	
	/**
	 * ȡ
	 *
	 * @return array
	 */
	public function getForumOrderByType($asc = true) {
		return $this->_getDao(self::FETCH_MAIN)->getForumOrderByType($asc);
	}

	/**
	 * Ӱ
	 *
	 * @param object $forumModel ģ
	 * return mixed
	 */
	public function addForum(PwForumDm $dm) {
		if (($result = $dm->beforeAdd()) !== true) {
			return $result;
		}
		return $this->_getDao(self::FETCH_ALL)->addForum($dm->getData());
	}
	
	/**
	 * 
	 * 
	 * @param string $keyword
	 */
	public function searchForum($keyword){
		return $this->_getDao(self::FETCH_MAIN)->searchForum($keyword);
	}
	
	public function searchDesignForum(PwForumSo $so, $limit = 20, $offset = 0) {
		return $this->_getDesignForumDao()->searchForum($so->getData(), $so->getOrderby(), $limit, $offset);
	}
	
	public function countSearchForum(PwForumSo $so) {
		return $this->_getDesignForumDao()->countSearchForum($so->getData());
	}
	
	/**
	 * °Ϣ
	 *
	 * @param object $dm Ϣ
	 * @param int $fetchmode  <ȻΪFETCH_*һֻ>
	 * return bool
	 */
	public function updateForum(PwForumDm $dm, $fetchmode = self::FETCH_ALL) {
		if (($result = $dm->beforeUpdate()) !== true) {
			return $result;
		}
		return $this->_getDao($fetchmode)->updateForum($dm->fid, $dm->getData(), $dm->getIncreaseData());
	}
	
	/**
	 * ȡӰ
	 *
	 * @param int $fid
	 * @return array
	 */
	public function getSubForums($fid) {
		return $this->_getDao()->getSubForums($fid);
	}

	/**
	 * ͳưͳ
	 *
	 * @param int $fid
	 * @return void
	 */
	public function updateForumStatistics($fid) {
		if (empty($fid)) return;
		$this->_getDao(self::FETCH_STATISTICS)->updateForumStatistics($fid, array_keys($this->getSubForums($fid)));
	}

	/**
	 * °Ϣ
	 *
	 * @param array $fids id
	 * @param object $dm Ϣ
	 * @param int $fetchmode  <ȻΪFETCH_*һֻ>
	 * return bool
	 */
	public function batchUpdateForum($fids, PwForumDm $dm, $fetchmode = self::FETCH_ALL) {
		if (empty($fids)) return false;
		if (($result = $dm->beforeUpdate()) !== true) {
			return $result;
		}
		return $this->_getDao($fetchmode)->batchUpdateForum($fids, $dm->getData(), $dm->getIncreaseData());
	}
	
	/**
	 * ɾһ
	 *
	 * @param int $fid id
	 * @return bool
	 */
	public function deleteForum($fid) {
		if (empty($fid)) return false;
		return $this->_getDao(self::FETCH_ALL)->deleteForum($fid);
	}

	protected function _getDaoMap() {
		return array(
			self::FETCH_MAIN		=> 'forum.dao.PwForumDao',
			self::FETCH_STATISTICS	=> 'forum.dao.PwForumStatisticsDao',
			self::FETCH_EXTRA		=> 'forum.dao.PwForumExtraDao'
		);
	}

	protected function _getDao($fetchmode = self::FETCH_MAIN) {
		return Wekit::loadDaoFromMap($fetchmode, $this->_getDaoMap(), 'PwForum');
	}
	
	protected function _getDesignForumDao(){
		return Wekit::loadDao('forum.dao.PwDesignForumDao');
	}
}