<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * ӸϢʱ
 * 
 * @author peihong <jhqblxt@gmail.com> Mar 26, 2012
 * @link
 * @copyright
 * @license
 */

class PwOvertime {
	
	/**
	 * ĳӹʱ
	 * 
	 * @param int $tid
	 * @param string $type
	 * @param int $overtime
	 */
	public function setOvertime($tid,$type,$overtime) {
		$tid = intval($tid);
		$overtime = intval($overtime);
		return $this->_getDao()->setOvertime($tid, $type, $overtime);
	}
	
	public function getOvertimeByTid($tid) {
		$tid = intval($tid);
		return $this->_getDao()->getOvertimeByTid($tid);
	}
	
	/**
	 * ȡĪ͵Ĳʱ
	 *
	 * @param int $tid
	 * @param string $type
	 * @return array
	 */
	public function getOvertimeByTidAndType($tid, $type) {
		$tid = intval($tid);
		return $this->_getDao()->getOvertimeByTidAndType($tid, $type);
	}
	
	/**
	 * öӵĲʱ
	 *
	 * @param array $tids
	 * @param string $type 
	 * @param int $overtime
	 * @return bool
	 */
	public function batchAdd($tids, $type, $overtime) {
		if (empty($tids) || !is_array($tids)) return false;
		$data = array();
		foreach ($tids as $tid) {
			$data[] = array(
				'tid' => $tid,
				'm_type' => $type,
				'overtime' => $overtime
			);
		}
		return $this->_getDao()->batchAdd($data);
	}
	
	/**
	 * ɾ
	 *
	 * @param array $ids
	 * @return bool
	 */
	public function batchDelete($ids) {
		if (!$ids || !is_array($ids)) return false;
		return $this->_getDao()->batchDelete($ids);
	}
	
	/**
	 * ɾӵĲʱ
	 *
	 * @param array $tids
	 * @param string $type 
	 * @return bool
	 */
	public function batchDeleteByTidAndType($tids, $type) {
		if (!$tids || !is_array($tids)) return false;
		return $this->_getDao()->batchDeleteByTidAndType($tids, $type);
	}
	
	protected function _getDao() {
		return Wekit::loadDao('forum.dao.PwOvertimeDao');
	}
}