<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * ӻ
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwThread.php 23306 2013-01-08 06:57:50Z jieyin $
 * @package forum
 */

class PwThread {
	
	const FETCH_MAIN = 1;		//ӻϢ
	const FETCH_CONTENT = 2;	//Ϣ
	const FETCH_ALL = 3;
	
	const SPECIAL_SORT_TOP1 = 101;
	const SPECIAL_SORT_TOP2 = 102;
	const SPECIAL_SORT_TOP3 = 103;

	const STATUS_LOCKED = 1;
	const STATUS_CLOSED = 2;
	const STATUS_DOWNED = 3;
	const STATUS_OPERATORLOG = 4;//ǷӲ־
	
	/**
	 * ȡϢ
	 *
	 * @param int $tid id
	 * @param int $fetchmode  <ȻΪFETCH_*һֻ>
	 * @return array
	 */
	public function getThread($tid, $fetchmode = self::FETCH_MAIN) {
		if (empty($tid)) return array();
		return $this->_getThreadDao($fetchmode)->getThread($tid);
	}
	
	/**
	 * ȡϢ
	 *
	 * @param array $tids tid
	 * @param int $fetchmode  <ȻΪFETCH_*һֻ>
	 * @return array
	 */
	public function fetchThread($tids, $fetchmode = self::FETCH_MAIN) {
		if (empty($tids) || !is_array($tids)) return array();
		return $this->_getThreadDao($fetchmode)->fetchThread($tids);
	}
	
	/**
	 * ȡĳб (ظ)
	 *
	 * @param int $fid id
	 * @param int $limit 
	 * @param int $offset ʼƫ
	 * @param int $fetchmode  <ȻΪFETCH_*һֻ>
	 * @return array
	 */
	public function getThreadByFid($fid, $limit, $offset = 0, $fetchmode = self::FETCH_MAIN) {
		return $this->_getThreadDao($fetchmode)->getThreadByFid($fid, $limit, $offset);
	}

	public function fetchThreadByTid($tids, $limit, $start, $fetchmode = self::FETCH_MAIN) {
		return $this->_getThreadDao($fetchmode)->fetchThreadByTid($tids, $limit, $start);
	}
	
	/**
	 * ͳư/ظ
	 *
	 * @param int $fid fid
	 * @return array
	 */
	public function countPosts($fid) {
		return $this->_getThreadDao()->countPosts($fid);
	}
	
	/**
	 * ȡб
	 */
	public function getThreadByFidAndType($fid, $type, $limit, $start, $fetchmode = self::FETCH_MAIN) {
		return $this->_getThreadDao($fetchmode)->getThreadByFidAndType($fid, $type, $limit, $start);
	}
	
	public function countThreadByFidAndType($fid, $type) {
		return $this->_getThreadDao(self::FETCH_MAIN)->countThreadByFidAndType($fid, $type);
	}
	
	/**
	 * ͳû
	 *
	 * @param int $uid
	 * @return int
	 */
	public function countThreadByUid($uid) {
		if (empty($uid)) return 0;
		return $this->_getThreadDao(self::FETCH_MAIN)->countThreadByUid($uid);
	}

	/**
	 * ȡû
	 *
	 * @param int $uid ûid
	 * @param int $limit 
	 * @param int $offset ʼƫ
	 * @param int $fetchmode  <ȻΪFETCH_*һֻ>
	 * @return array
	 */
	public function getThreadByUid($uid, $limit = 0, $offset = 0, $fetchmode = self::FETCH_MAIN) {
		if (empty($uid)) return array();
		return $this->_getThreadDao($fetchmode)->getThreadByUid($uid, $limit, $offset);
	}
	
	/**
	 * ȡĳû
	 *
	 * @param int $fid id
	 * @param mixed $uids ûid (int|array)
	 * @param int $limit 
	 * @param int $offset ʼƫ
	 * @param int $fetchmode  <ȻΪFETCH_*һֻ>
	 * @return array
	 */
	public function getThreadsByFidAndUids($fid, $uids, $limit = 0, $offset = 0, $fetchmode = self::FETCH_MAIN) {
		if (empty($fid) || empty($uids)) return array();
		is_array($uids) || $uids = array($uids);
		return $this->_getThreadDao($fetchmode)->getThreadsByFidAndUids($fid, $uids, $limit, $offset);
	}
	
	/**
	 * 
	 * עӿֻṩݲزӷӿ PwPost::execute()
	 *
	 * @param object $topicDm ģ
	 * @return mixed
	 */
	public function addThread(PwTopicDm $topicDm) {
		if (($result = $topicDm->beforeAdd()) !== true) {
			return $result;
		}
		return $this->_getThreadDao(self::FETCH_ALL)->addThread($topicDm->getSetData());
	}
	
	/**
	 * 
	 *
	 * @param object $topicDm ģ
	 * @param int $fetchmode  <ȻΪFETCH_*һֻ>
	 * @return mixed
	 */
	public function updateThread(PwTopicDm $topicDm, $fetchmode = self::FETCH_ALL) {
		if (($result = $topicDm->beforeUpdate()) !== true) {
			return $result;
		}
		return $this->_getThreadDao($fetchmode)->updateThread($topicDm->tid, $topicDm->getData(), $topicDm->getIncreaseData(), $topicDm->getBitData());
	}
	
	/**
	 * 
	 *
	 * @param array $tids id
	 * @param object $topicDm ģ
	 * @param int $fetchmode  <ȻΪFETCH_*һֻ>
	 * @return mixed
	 */
	public function batchUpdateThread($tids, PwTopicDm $topicDm, $fetchmode = self::FETCH_ALL) {
		if (empty($tids)) return false;
		if (($result = $topicDm->beforeUpdate()) !== true) {
			return $result;
		}
		return $this->_getThreadDao($fetchmode)->batchUpdateThread($tids, $topicDm->getData(), $topicDm->getIncreaseData(), $topicDm->getBitData());
	}
	
	/**
	 * ԭdisabled
	 *
	 * @param array $tids
	 * @return bool
	 */
	public function revertTopic($tids) {
		if (empty($tids) || !is_array($tids)) return false;
		return $this->_getThreadDao(self::FETCH_MAIN)->revertTopic($tids);
	}

	/**
	 * ɾ
	 * עӿֻṩݲزɾӿ PwDeleteTopic::execute()
	 * 
	 * @param int $tid
	 */
	public function deleteThread($tid) {
		if (!$tid) return false;
		return $this->_getThreadDao(self::FETCH_ALL)->deleteThread($tid);
	}
	
	/**
	 * ɾ
	 * עӿֻṩݲزɾӿ PwDeleteTopic::execute()
	 * 
	 * @param array $tids
	 */
	public function batchDeleteThread($tids) {
		if (empty($tids) || !is_array($tids)) return false;
		return $this->_getThreadDao(self::FETCH_ALL)->batchDeleteThread($tids);
	}
	
	/**
	 * ͳ()
	 *
	 * @param object $so
	 * @return int
	 */
	public function countSearchThread(PwThreadSo $so) {
		return $this->_getThreadMergeDao()->countSearchThread($so->getData());
	}

	/**
	 * 
	 *
	 * @param object $so
	 * @return array
	 */
	public function searchThread(PwThreadSo $so, $limit = 20, $offset = 0, $fetchmode = self::FETCH_MAIN) {
		return $this->_getThreadMergeDao()->searchThread($fetchmode, $so->getData(), $so->getOrderby(), $limit, $offset);
	}


	/****************** ӿ ******************\

	\****************** ǻظӿ ******************/



	/**
	 * ȡһظ
	 *
	 * @param int $pid ظid
	 * @return array
	 */
	public function getPost($pid) {
		if (!$pid) return array();
		return $this->_getPostDao()->getPost($pid);
	}
	
	/**
	 * ȡظ
	 *
	 * @param array $pids ظids
	 * @return array
	 */
	public function fetchPost($pids) {
		if (empty($pids) || !is_array($pids)) return false;
		return $this->_getPostDao()->fetchPost($pids);
	}

	/**
	 * ȡһӵĻظб
	 *
	 * @param int $tid id
	 * @param int $limit
	 * @param int $offset
	 * @return array
	 */
	public function getPostByTid($tid, $limit = 20, $offset = 0, $asc = true) {
		if (empty($tid)) return array();
		return $this->_getPostDao()->getPostByTid($tid, $limit, $offset, $asc);
	}
	
	/**
	 * ͳûĻظ
	 *
	 * @param int $uid
	 * @return int
	 */
	public function countPostByUid($uid) {
		if (empty($uid)) return 0;
		return $this->_getPostDao()->countPostByUid($uid);
	}

	/**
	 * ȡûĻظ
	 *
	 * @param int $uid ûid
	 * @param int $limit 
	 * @param int $offset ʼƫ
	 * @return array
	 */
	public function getPostByUid($uid, $limit = 20, $offset = 0) {
		if (empty($uid)) return array();
		return $this->_getPostDao()->getPostByUid($uid, $limit, $offset);
	}
	
	/**
	 * ͳû(A)(B)еĻظ
	 *
	 * @param int $tid
	 * @param int $uid
	 * @return int
	 */
	public function countPostByTidAndUid($tid, $uid) {
		if (empty($tid) || empty($uid)) return 0;
		return $this->_getPostDao()->countPostByTidAndUid($tid, $uid);
	}
	
	/**
	 * ͳ(A)еIDСڻظ(B)Ļظ
	 *
	 * @param int $tid
	 * @param int $pid
	 * @return int
	 */
	public function countPostByTidUnderPid($tid, $pid) {
		if (empty($tid) || empty($pid)) return 0;
		return $this->_getPostDao()->countPostByTidUnderPid($tid, $pid);
	}
	
	/**
	 * ȡû(A)(B)еĻظ
	 *
	 * @param int $tid
	 * @param int $uid
	 * @param int $limit
	 * @param int $offset
	 * @param bool $asc
	 * @return array
	 */
	public function getPostByTidAndUid($tid, $uid, $limit = 20, $offset = 0, $asc = true) {
		if (empty($tid) || empty($uid)) return array();
		return $this->_getPostDao()->getPostByTidAndUid($tid, $uid, $limit, $offset, $asc);
	}

	/**
	 * ͳƻظ()
	 *
	 * @param object $so
	 * @return int
	 */
	public function countSearchPost(PwPostSo $so) {
		return $this->_getPostDao()->countSearchPost($so->getData());
	}

	/**
	 * ظ
	 *
	 * @param object $so
	 * @return array
	 */
	public function searchPost(PwPostSo $so, $limit = 20, $offset = 0) {
		return $this->_getPostDao()->searchPost($so->getData(), $so->getOrderby(), $limit, $offset);
	}

	/**
	 * һظ
	 *
	 * @param object $replyDm ظģ
	 * @return array
	 */
	public function addPost(PwReplyDm $replyDm) {
		if (($result = $replyDm->beforeAdd()) !== true) {
			return $result;
		}
		return $this->_getPostDao()->addPost($replyDm->getData());
	}
	
	/**
	 * »ظ
	 *
	 * @param int $pid ظid
	 * @param object $replyDm ظģ
	 * @return mixed
	 */
	public function updatePost(PwReplyDm $replyDm) {
		if (($result = $replyDm->beforeUpdate()) !== true) {
			return $result;
		}
		return $this->_getPostDao()->updatePost($replyDm->pid, $replyDm->getData(), $replyDm->getIncreaseData());
	}
	
	/**
	 * 
	 *
	 * @param array $pids ظid
	 * @param object $replyDm ģ
	 * @return mixed
	 */
	public function batchUpdatePost($pids, PwReplyDm $replyDm) {
		if (empty($pids) || !is_array($pids)) return false;
		if (($result = $replyDm->beforeUpdate()) !== true) {
			return $result;
		}
		return $this->_getPostDao()->batchUpdatePost($pids, $replyDm->getData(), $replyDm->getIncreaseData());
	}

	/**
	 * 
	 *
	 * @param array $tids id
	 * @param object $replyDm ģ
	 * @return mixed
	 */
	public function batchUpdatePostByTid($tids, PwReplyDm $replyDm) {
		if (empty($tids)) return false;
		if (($result = $replyDm->beforeUpdate()) !== true) {
			return $result;
		}
		return $this->_getPostDao()->batchUpdatePostByTid($tids, $replyDm->getData(), $replyDm->getIncreaseData());
	}

	/**
	 * ԭdisabled
	 *
	 * @param array $tids
	 * @return bool
	 */
	public function revertPost($tids) {
		if (empty($tids) || !is_array($tids)) return false;
		return $this->_getPostDao()->revertPost($tids);
	}
	
	/**
	 * ݻظidɾظ
	 *
	 * @param array $pids ظid
	 * @return bool
	 */
	public function batchDeletePost($pids) {
		if (empty($pids) || !is_array($pids)) return false;
		return $this->_getPostDao()->batchDeletePost($pids);
	}

	/**
	 * idɾظ
	 *
	 * @param array $tids id
	 * @return bool
	 */
	public function batchDeletePostByTid($tids) {
		if (empty($tids) || !is_array($tids)) return false;
		return $this->_getPostDao()->batchDeletePostByTid($tids);
	}
	
	public function getHit($tid) {
		return $this->_getThreadHitsDao()->get(intval($tid));
	}

	public function fetchHit($tids) {
		if (empty($tids) || !is_array($tids)) return array();
		return $this->_getThreadHitsDao()->fetch($tids);
	}

	public function updateHits($tid, $hits) {
		return $this->_getThreadHitsDao()->update(intval($tid), intval($hits));
	}

	public function syncHits() {
		return $this->_getThreadHitsDao()->syncHits();
	}

	protected function _getDaoMap() {
		return array(
			self::FETCH_MAIN	=> 'forum.dao.PwThreadsDao',
			self::FETCH_CONTENT	=> 'forum.dao.PwThreadsContentDao'
		);
	}

	protected function _getThreadDao($fetchmode = self::FETCH_MAIN) {
		return Wekit::loadDaoFromMap($fetchmode, $this->_getDaoMap(), 'PwThread');
	}

	protected function _getThreadMergeDao() {
		return Wekit::loadDao('forum.dao.PwThreadMergeDao');
	}

	protected function _getPostDao() {
		return Wekit::loadDao('forum.dao.PwPostsDao');
	}

	protected function _getThreadHitsDao() {
		return Wekit::loadDao('forum.dao.PwThreadsHitsDao');
	}
}