<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * ӹ¼ / ds
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwThreadBuy.php 24066 2013-01-21 07:30:33Z jinlong.panjl $
 * @package forum
 */

class PwThreadBuy {
	
	/**
	 * ͳӵĳ۶
	 *
	 * @param int $tid id
	 * @param int $pid ظid
	 * @return int
	 */
	public function sumCost($tid, $pid = 0) {
		if (empty($tid)) return 0;
		return $this->_getDao()->sumCost($tid, $pid);
	}

	/**
	 * ȡһ¼
	 *
	 * @param int $tid id
	 * @param int $pid ظid
	 * @param int $uid ûid
	 * @return array
	 */
	public function get($tid, $pid, $uid) {
		if (empty($tid) || empty($uid)) return array();
		return $this->_getDao()->get($tid, $pid, $uid);
	}

	/**
	 * ȡĳһ¥й¼
	 *
	 * @param int $tid id
	 * @param int $pid ظid
	 * @return bool
	 */
	public function countByTidAndPid($tid, $pid) {
		if (empty($tid)) return array();
		return $this->_getDao()->countByTidAndPid($tid, $pid);
	}
	
	/**
	 * ȡĳһ¥й¼
	 *
	 * @param int $tid id
	 * @param int $pid ظid
	 * @return bool
	 */
	public function getByTidAndPid($tid, $pid, $limit = 20, $offset = 0) {
		if (empty($tid)) return array();
		return $this->_getDao()->getByTidAndPid($tid, $pid, $limit, $offset);
	}
	
	/**
	 * ȡ(A)û(B)й¼
	 *
	 * @param int $tid (A)
	 * @param int $uid û(B)
	 * @return bool
	 */
	public function getByTidAndUid($tid, $uid) {
		if (empty($tid) || empty($uid)) return array();
		return $this->_getDao()->getByTidAndUid($tid, $uid);
	}
	
	/**
	 * һ¼
	 *
	 * @param PwThreadBuyDm $dm ӹ¼ģ
	 * return mixed
	 */
	public function add(PwThreadBuyDm $dm) {
		if (($result = $dm->beforeAdd()) !== true) {
			return $result;
		}
		return $this->_getDao()->add($dm->getData());
	}

	/**
	 * PwThreadsBuyDao
	 *
	 * @return PwThreadsBuyDao
	 */
	protected function _getDao() {
		return Wekit::loadDao('forum.dao.PwThreadsBuyDao');
	}
}