<?php

/**
 * Ӿر
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwThreadDigestIndex.php 15975 2012-08-16 09:40:09Z xiaoxia.xuxx $
 * @package src.service.forum
 */
class PwThreadDigestIndex {
	
	/**
	 * ݰIDȡ
	 *
	 * @param int $cid 
	 * @param int $limit ѯ
	 * @param int $offset ʼѯλ
	 * @param string $order ʽ
	 * @return array
	 */
	public function getThreadsByCid($cid, $limit = 20, $offset = 0, $order = 'lastpost') {
		if (empty($cid)) return array();
		return $this->_getDao()->getThreadsByCid($cid, $limit, $offset, $order);
	}
	
	/**
	 * ݰIDͳƾ
	 *
	 * @param int $cid
	 * @return int
	 */
	public function countByCid($cid) {
		if (empty($cid)) return 0;
		return $this->_getDao()->countByCid($cid);
	}
	
	/**
	 * ݰIDȡðľб
	 *
	 * @param int $fid  ID
	 * @param int $typeid 
	 * @param int $limit
	 * @param int $offset
	 * @param string $order
	 * @return array
	 */
	public function getThreadsByFid($fid, $typeid = 0, $limit = 20, $offset = 0, $order = 'lastpost') {
		if (empty($fid)) return 0;
		return $this->_getDao()->getThreadsByFid($fid, intval($typeid), $limit, $offset, $order);
	}
	
	/**
	 * ݰIDͳƸðľб
	 *
	 * @param int $fid  ID
	 * @param int $typeid 
	 * @return int
	 */
	public function countByFid($fid, $typeid = 0) {
		if (empty($fid)) return 0;
		return $this->_getDao()->countByFid($fid, $typeid);
	}
	
	/**
	 * Ӿ
	 *
	 * @param int $tid
	 * @param array $fields
	 * @return boolean
	 */
	public function addThreadDigest(PwThreadDigestDm $dm) {
		if (true !== ($r = $dm->beforeAdd())) {
			return $r;
		}
		return $this->_getDao()->addThread($dm->tid, $dm->getData());
	}
	
	/**
	 * IDɾ
	 *
	 * @param array $tids
	 * @return int
	 */
	public function batchDeleteThread($tids) {
		if (empty($tids)) return 0;
		return $this->_getDao()->batchDeleteThread($tids);
	}
	
	/**
	 * Ӿ
	 *
	 * @param array $dms
	 */
	public function batchAddDigest(array $dms) {
		$data = array();
		foreach ($dms as $_dm ) {
			if (!$_dm instanceof PwThreadDigestDm) {
				return new PwError('BBS:digest.dm.data.format.error');
			}
			if (($r = $_dm->beforeAdd()) instanceof PwError) {
				return $r;
			}
			$_data = $_dm->getData();
			$_data['tid'] = $_dm->tid;
			$data[] = $_data;
		}
		return $this->_getDao()->batchAddDigest($data);
	}
	
	/**
	 * ȡDAO
	 *
	 * @return PwThreadsDigestIndexDao
	 */
	private function _getDao() {
		return Wekit::loadDao('SRV:forum.dao.PwThreadsDigestIndexDao');
	}
}