<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('SRV:forum.PwThread');

/**
 * չ,õĽӿ
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwThreadExpand.php 22254 2012-12-20 08:03:33Z jinlong.panjl $
 * @package forum
 */

class PwThreadExpand {
	
	/**
	 * ȡ(A)ظʱ(B)
	 *
	 * @param int $fid
	 * @param int $lastpostTime
	 * @param int $limit
	 * @param int $offset
	 * @return array
	 */
	public function getThreadByFidOverTime($fid, $lastpostTime, $limit = 10, $offset = 0) {
		$fid = intval($fid);
		if (empty($fid)) return array();
		return $this->_getThreadDao()->getThreadByFidOverTime($fid, $lastpostTime, $limit, $offset);
	}

	/**
	 * ȡ(A)ظʱС(B)
	 *
	 * @param int $fid
	 * @param int $lastpostTime
	 * @param int $limit
	 * @param int $offset
	 * @return array
	 */
	public function getThreadByFidUnderTime($fid, $lastpostTime, $limit = 10, $offset = 0) {
		$fid = intval($fid);
		if (empty($fid)) return array();
		return $this->_getThreadDao()->getThreadByFidUnderTime($fid, $lastpostTime, $limit, $offset);
	}

	/**
	 * ȡû
	 *
	 * @param array $uids uid
	 * @return array
	 */
	public function fetchThreadByUid($uids) {
		if (empty($uids) || !is_array($uids)) return array();
		return $this->_getThreadDao()->fetchThreadByUid($uids);
	}

	/**
	 * ͳûĳʱڰ(A)
	 *
	 * @param int $fid
	 * @param int $time
	 * @param int $num
	 * @return array
	 */
	public function countUserThreadByFidAndTime($fid, $time, $num) {
		$fid = intval($fid);
		if (empty($fid)) return array();
		return $this->_getThreadDao()->countUserThreadByFidAndTime($fid, $time, $num);
	}

	/**
	 * ͳûĳʱڰ(A)ظ
	 *
	 * @param int $fid
	 * @param int $time
	 * @param int $num
	 * @return array
	 */
	public function countUserPostByFidAndTime($fid, $time, $num) {
		$fid = intval($fid);
		if (empty($fid)) return array();
		return $this->_getPostDao()->countUserPostByFidAndTime($fid, $time, $num);
	}

	public function countThreadsByFid() {
		return $this->_getThreadDao()->countThreadsByFid();
	}

	public function countPostsByFid() {
		return $this->_getPostDao()->countPostsByFid();
	}
	
	/**
	 * uidͳ˺δ˵
	 *
	 * @param int $uid
	 * @return int
	 */
	public function countDisabledThreadByUid($uid) {
		$uid = intval($uid);
		if ($uid < 1) return 0;
		return $this->_getThreadDao()->countDisabledThreadByUid($uid);
	}

	/**
	 * uidȡ˺δ˵
	 *
	 * @param int $uid ûid
	 * @param int $limit 
	 * @param int $offset ʼƫ
	 * @param int $fetchmode  <ȻΪFETCH_*һֻ>
	 * return array
	 */
	public function getDisabledThreadByUid($uid, $limit=0, $offset=0) {
		$uid = intval($uid);
		if ($uid < 1) return array();
		return $this->_getThreadDao()->getDisabledThreadByUid($uid, $limit, $offset);
	}
	
	/**
	 * ͳû˺δ˻ظ
	 *
	 * @param int $uid
	 * @return int
	 */
	public function countDisabledPostByUid($uid) {
		if (empty($uid)) return 0;
		return $this->_getPostDao()->countDisabledPostByUid($uid);
	}

	/**
	 * ȡû˺δ˻ظ
	 *
	 * @param int $uid ûid
	 * @param int $limit 
	 * @param int $offset ʼƫ
	 * return array
	 */
	public function getDisabledPostByUid($uid, $limit = 20, $offset = 0) {
		if (empty($uid)) return array();
		return $this->_getPostDao()->getDisabledPostByUid($uid, $limit, $offset);
	}

	protected function _getThreadDao() {
		return Wekit::loadDao('forum.dao.PwThreadExpandDao');
	}

	protected function _getPostDao() {
		return Wekit::loadDao('forum.dao.PwPostExpandDao');
	}
}