<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * 
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwThreadIndex.php 17055 2012-08-30 11:02:11Z jieyin $
 * @package forum
 */

class PwThreadIndex {
	
	/**
	 * ͳ
	 *
	 * @return int
	 */
	public function count() {
		return $this->_getDao()->count();
	}
	
	/**
	 * ͳڰе
	 *
	 * @param array $fids id
	 * @return int
	 */
	public function countThreadInFids($fids) {
		if (empty($fids) || !is_array($fids)) return 0;
		return $this->_getDao()->countThreadInFids($fids);
	}
	
	/**
	 * ͳвڰе
	 *
	 * @param array $fids id
	 * @return int
	 */
	public function countThreadNotInFids($fids) {
		if (empty($fids) || !is_array($fids)) return $this->count();
		return $this->_getDao()->countThreadNotInFids($fids);
	}
	
	/**
	 * ȡ
	 *
	 * @param int $limit
	 * @param int $offset
	 * @param string $order ʽ
	 * @return array
	 */
	public function fetch($limit, $offset, $order = 'lastpost') {
		$result = $this->_getDao()->fetch($limit, $offset, $order);
		return array_keys($result);
	}

	/**
	 * ȡڰе
	 *
	 * @param array $fids id
	 * @param int $limit
	 * @param int $offset
	 * @param string $order ʽ
	 * @return array
	 */
	public function fetchInFid($fids, $limit, $offset, $order = 'lastpost') {
		if (empty($fids) || !is_array($fids)) return array();
		$result = $this->_getDao()->fetchInFid($fids, $limit, $offset, $order);
		return array_keys($result);
	}

	/**
	 * ȡڰе
	 *
	 * @param array $fids id
	 * @param int $limit
	 * @param int $offset
	 * @param string $order ʽ
	 * @return array
	 */
	public function fetchNotInFid($fids, $limit, $offset, $order = 'lastpost') {
		if (empty($fids) || !is_array($fids)) return $this->fetch($limit, $offset, $order);
		$result = $this->_getDao()->fetchNotInFid($fids, $limit, $offset, $order);
		return array_keys($result);
	}
	
	/**
	 * ɾ
	 *
	 * @param int $limit
	 * @return bool
	 */
	public function deleteOver($limit) {
		if ($limit < 1) return false;
		return $this->_getDao()->deleteOver($limit);
	}

	protected function _getDao() {
		return Wekit::loadDao('forum.dao.PwThreadsIndexDao');
	}
}