<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('WIND:utility.WindSecurity');

/**
 * ҵģ
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @license http://www.phpwind.com
 * @version $Id: PwForumBo.php 25814 2013-03-25 05:42:52Z jieyin $
 * @package forum
 */

class PwForumBo {
	
	public $fid;
	public $foruminfo = array();
	public $forumset = array();

	public function __construct($fid, $fetchAll = false) {
		$this->fid = intval($fid);
		$forumService = $this->_getForumService();
		$this->foruminfo = $forumService->getForum($fid, $fetchAll ? PwForum::FETCH_ALL : (PwForum::FETCH_MAIN | PwForum::FETCH_EXTRA));
		$this->foruminfo['settings_basic'] && $this->forumset = unserialize($this->foruminfo['settings_basic']);
		if (!is_array($this->forumset['allowtype'])) $this->forumset['allowtype'] = array();
	}
	
	/**
	 * ǷΪİ
	 *
	 * @return bool
	 */
	public function isForum($allowcate = false) {
		if (empty($this->foruminfo) || !$allowcate && $this->foruminfo['type'] == 'category') {
			return false;
		}
		return true;
	}
	
	/**
	 * ǷΪŰ
	 *
	 * @return bool
	 */
	public function isOpen() {
		return !$this->foruminfo['allow_visit'] && !$this->foruminfo['allow_read'] && !$this->foruminfo['password'];
	}

	/**
	 * ǷΪӰ
	 *
	 * @return bool
	 */
	public function isSub() {
		return ($this->foruminfo['type'] == 'sub' || $this->foruminfo['type'] == 'sub2');
	}
	
	/**
	 * ûǷð
	 *
	 * @param int $uid ûid
	 * @return bool
	 */
	public function isJoin($uid) {
		return !!Wekit::load('forum.PwForumUser')->get($uid, $this->fid);
	}
	
	/**
	 * ûǷǸðİ
	 *
	 * @param string $username û
	 * @return bool
	 */
	public function isBM($username) {
		if (!$username) return false;
		if ($this->foruminfo['manager'] && strpos($this->foruminfo['manager'], ",$username,") !== false) return true;
		if ($this->foruminfo['uppermanager'] && strpos($this->foruminfo['uppermanager'], ",$username,") !== false) return true;
		return false;
	}

	/**
	 * ûȨ
	 *
	 * @param object $user û
	 * @return bool
	 */
	public function allowVisit(PwUserBo $user) {
		if (!$this->foruminfo['allow_visit']) return true;
		return $user->inGroup(explode(',', $this->foruminfo['allow_visit']));
	}

	/**
	 * ûĶȨ
	 *
	 * @param object $user û
	 * @return bool
	 */
	public function allowRead(PwUserBo $user) {
		if (!$this->foruminfo['allow_read']) return true;
		return $user->inGroup(explode(',', $this->foruminfo['allow_read']));
	}

	/**
	 * û鷢Ȩ
	 *
	 * @param object $user û
	 * @return bool
	 */
	public function allowPost(PwUserBo $user) {
		if (!$this->foruminfo['allow_post']) return true;
		return $user->inGroup(explode(',', $this->foruminfo['allow_post']));
	}

	/**
	 * û鷢ظȨ
	 *
	 * @param object $user û
	 * @return bool
	 */
	public function allowReply(PwUserBo $user) {
		if (!$this->foruminfo['allow_reply']) return true;
		return $user->inGroup(explode(',', $this->foruminfo['allow_reply']));
	}
	
	/**
	 * ûϴȨ
	 *
	 * @param object $user û
	 * @return bool
	 */
	public function allowUpload(PwUserBo $user) {
		if (!$this->foruminfo['allow_upload']) return true;
		return $user->inGroup(explode(',', $this->foruminfo['allow_upload']));
	}
	
	/**
	 * ûȨ
	 *
	 * @param object $user û
	 * @return bool
	 */
	public function allowDownload(PwUserBo $user) {
		if (!$this->foruminfo['allow_download']) return true;
		return $user->inGroup(explode(',', $this->foruminfo['allow_download']));
	}

	/**
	 * ȡϼ
	 * 
	 * @return array
	 */
	public function getForumChain() {
		$guide = array();
		if ($this->foruminfo['type'] == 'category') {
			$guide[] = array(strip_tags($this->foruminfo['name']), WindUrlHelper::createUrl('bbs/cate/run', array('fid' => $this->fid)));
			return $guide;
		}
		$guide[] = array(strip_tags($this->foruminfo['name']), WindUrlHelper::createUrl('bbs/thread/run', array('fid' => $this->fid)));
		$info = $this->getParentForums();
		$count = count($info);
		$i = 0;
		foreach ($info as $fid => $value) {
			array_unshift($guide, array($value, WindUrlHelper::createUrl('bbs/' . (++$i < $count ? 'thread' : 'cate') . '/run', array('fid' => $fid))));
		}
		return $guide;
	}
	
	/**
	 * 鵼Ϣ
	 *
	 * @return string
	 */
	public function headguide() {
		$bbsname = Wekit::C('site', 'info.name');
		$headguide = '<a href="' . WindUrlHelper::createUrl('') . '" title="' . $bbsname . '" class="home">ҳ</a>';
		$guide = $this->getForumChain();
		foreach ($guide as $key => $value) {
			$headguide .= $this->bulidGuide($value);
		}
		return $headguide;
	}
	
	/**
	 * ɵڵϢ
	 *
	 * @param array $guide ڵϢ
	 * @return string
	 */
	public function bulidGuide($guide) {
		if ($guide[1]) {
			return '<em>&gt;</em><a href="' . $guide[1] . '">' . WindSecurity::escapeHTML($guide[0]) . '</a>';
		}
		return '<em>&gt;</em>' . WindSecurity::escapeHTML($guide[0]);
	}
	
	/** 
	 * ȡӰб
	 *
	 * @return array
	 */
	public function getSubForums($isshow = 0, $withData = false) {
		$result = $this->_getForumService()->getSubForums($this->fid);
		if ($isshow) {
			foreach ($result as $key => $value) {
				if (!$value['isshow']) unset($result[$key]);
			}
		}
		if ($withData) {
			$ids = array_keys($result);
			$datas = $this->_getForumService()->fetchForum($ids, PwForum::FETCH_STATISTICS);
			foreach ($result as $key => $value) {
				$result[$key] = array_merge($value, isset($datas[$key]) ? $datas[$key] : array());
				$_manager = array_unique(explode(',', $value['manager']));
				$result[$key]['manager'] = array();
				foreach ($_manager as $_v) {
					if ($_v) $result[$key]['manager'][] = $_v;
				}
			}
		}
		return $result;
	}
	
	/** 
	 * ȡб
	 *
	 * @return array
	 */
	public function getManager() {
		if (!$this->foruminfo['manager']) return array();
		return explode(',', trim($this->foruminfo['manager'], ','));
	}
	
	/**
	 * ȡϼid
	 *
	 * @return array
	 */
	public function getParentFids() {
		return $this->foruminfo['fup'] ? explode(',', $this->foruminfo['fup']) : array();
	}
	
	/**
	 * ȡϼб
	 *
	 * @return array
	 */
	public function getParentForums() {
		if (!$fids = $this->getParentFids()) return array();
		$forums = explode("\t", $this->foruminfo['fupname']);
		$result = array();
		foreach ($fids as $key => $fid) {
			$result[$fid] = $forums[$key];
		}
		return $result;
	}
	
	/** 
	 * ȡid
	 *
	 * @return int
	 */
	public function getCateId() {
		if ($this->foruminfo['type'] == 'category') return $this->fid;
		$array = explode(',', $this->foruminfo['fup']);
		return array_pop($array);
	}
	
	/**
	 * ȡ
	 *
	 * @param PwUserBo $user
	 * @return array
	 */
	public function getThreadType(PwUserBo $user) {
		if (!is_array($this->forumset['typeorder'])) return array();
		asort($this->forumset['typeorder']);
		$array = array();
		$tType = Wekit::load('forum.srv.PwThreadType')->getTtype();
		foreach ($this->forumset['typeorder'] as $key => $value) {
			if (isset($tType[$key]) && in_array($key, $this->forumset['allowtype']) && ($tType[$key][2] === true || $user->getPermission($tType[$key][2]))) {
				$array[$key] = $tType[$key];
			}
		}
		return $array;
	}
	
	/**
	 * ȡ
	 */
	public function getCreditSet($operate = '') {
		$creditset = $this->foruminfo['settings_credit'] ? unserialize($this->foruminfo['settings_credit']) : array();
		if ($operate) {
			return isset($creditset[$operate]) ? $creditset[$operate] : array();
		}
		return $creditset;
	}

	/**
	 * һʱ°Ϣ
	 *
	 * @param int $tid id
	 * @param string $username û
	 * @param string $subject ӱ
	 * @return bool
	 */
	public function addThread($tid, $username, $subject) {
		return Wekit::load('forum.srv.PwForumService')->updateStatistics($this, 1, 0, 1, array(
			'tid' => $tid, 'username' => $username, 'subject' => $subject
		));
	}
	
	/**
	 * һظʱ°Ϣ
	 *
	 * @param int $tid id
	 * @param string $username û
	 * @param string $subject ӱ
	 * return bool
	 */
	public function addPost($tid, $username, $subject) {
		return Wekit::load('forum.srv.PwForumService')->updateStatistics($this, 0, 1, 1, array(
			'tid' => $tid, 'username' => $username, 'subject' => $subject
		));
	}

	/**
	 * Enter description here ...
	 *
	 * @return PwForum
	 */
	protected function _getForumService() {
		return Wekit::load('forum.PwForum');
	}
}