<?php

/**
 * 
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwThreadsDigestIndexDao.php 25506 2013-03-18 09:43:10Z jieyin $
 * @package src.service.forum.dao
 */
class PwThreadsDigestIndexDao extends PwBaseDao {

	protected $_table = 'bbs_threads_digest_index';
	protected $_pk = 'tid';
	protected $_dataStruct = array('tid', 'cid', 'fid', 'disabled', 'topic_type', 'created_time', 'lastpost_time', 'operator', 'operator_userid', 'operator_time');
	protected $_threadTable = 'bbs_threads';
	
	/**
	 * ݰIDȡ
	 *
	 * @param int $cid 
	 * @param int $limit ѯ
	 * @param int $offset ʼѯλ
	 * @param string $order ʽ
	 * @return array
	 */
	public function getThreadsByCid($cid, $limit, $offset, $order) {
		list($field, $idx) = $this->_getOrderFieldAndIndex($order);
		$sql = $this->_bindSql('SELECT * FROM %s FORCE INDEX(%s) WHERE cid=? AND disabled=0 ORDER BY %s DESC %s', $this->getTable(), $idx, $field, $this->sqlLimit($limit, $offset));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($cid), 'tid');
	}
	
	/**
	 * ݰIDͳƾ
	 *
	 * @param int $cid
	 * @return int
	 */
	public function countByCid($cid) {
		$sql = $this->_bindTable('SELECT COUNT(*) as count FROM %s WHERE cid=? AND disabled=0');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getValue(array($cid));
	}
	
	/**
	 * ݰIDȡðľб
	 *
	 * @param int $fid  ID
	 * @param int $typeid 
	 * @param int $limit
	 * @param int $offset
	 * @param string $order
	 * @return array
	 */
	public function getThreadsByFid($fid, $typeid, $limit, $offset, $order) {
		list($field, $idx) = $this->_getOrderFieldAndIndex($order, true);
		$sql = $this->_bindSql('SELECT * FROM %s FORCE INDEX(%s) WHERE fid=? AND disabled=0 %s ORDER BY %s DESC %s', $this->getTable(), $idx, $typeid ? ' AND topic_type = ' . intval($typeid) : '', $field, $this->sqlLimit($limit, $offset));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($fid), 'tid');
	}
	
	/**
	 * ݰIDͳƸðľб
	 *
	 * @param int $fid  ID
	 * @param int $typeid 
	 * @return int
	 */
	public function countByFid($fid, $typeid) {
		$sql = $this->_bindSql('SELECT COUNT(*) as count FROM %s WHERE fid=? AND disabled=0 %s', $this->getTable(), $typeid ? ' AND topic_type = ' . intval($typeid) : '');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getValue(array($fid));
	}
	
	/**
	 * Ӿ
	 *
	 * @param int $tid
	 * @param array $fields
	 * @return boolean
	 */
	public function addThread($tid, $fields) {
		if (1 != $fields['digest']) return true;
		$fields['tid'] = $tid;
		$fields = $this->_processField($fields);
		return $this->_add($fields, false);
	}
	
	/**
	 * Ӿ
	 *
	 * @param array $data
	 * @return int
	 */
	public function batchAddDigest($data) {
		$clear = array();
		foreach ($data as $_tmp) {
			$clear[] = array(
				intval($_tmp['tid']),
				intval($_tmp['cid']),
				intval($_tmp['fid']),
				isset($_tmp['disabled']) ? $_tmp['disabled'] : 0,
				intval($_tmp['topic_type']),
				intval($_tmp['created_time']),
				intval($_tmp['lastpost_time']),
				$_tmp['operator'],
				intval($_tmp['operator_userid']),
				intval($_tmp['operator_time'])
			);
		}
		$sql = $this->_bindSql('REPLACE INTO %s (`tid`, `cid`, `fid`, `disabled`, `topic_type`, `created_time`, `lastpost_time`, `operator`, `operator_userid`, `operator_time`) VALUES	%s', $this->getTable(), $this->sqlMulti($clear));
		return $this->getConnection()->execute($sql);
	}

	/**
	 * ¾Ϣ
	 *
	 * @param int $tid
	 * @param array $fields
	 * @param array $increaseFields
	 * @return int
	 */
	public function updateThread($tid, $fields, $increaseFields = array()) {
		$fields = $this->_processField($fields);
		return $this->_update($tid, $fields, $increaseFields);
	}

	/**
	 * ¾Ϣ
	 *
	 * @param array $tids
	 * @param array $fields
	 * @param array $increaseFields
	 * @return boolean
	 */
	public function batchUpdateThread($tids, $fields, $increaseFields = array()) {
		$fields = $this->_processField($fields);
		return $this->_batchUpdate($tids, $fields, $increaseFields);
	}

	/**
	 * ԭӵʱ򣬻ԭ
	 *
	 * @param array $tids
	 * @return boolean
	 */
	public function revertTopic($tids) {
		/* $sql = $this->_bindSql('UPDATE %s a LEFT JOIN %s b ON a.tid=b.tid SET a.disabled=b.disabled WHERE a.tid IN %s', $this->getTable(), $this->getTable($this->_threadTable), $this->sqlImplode($tids));
		return $this->getConnection()->execute($sql); */
	}
	
	/**
	 * ɾϢ
	 *
	 * @param int $tid
	 * @return int
	 */
	public function deleteThread($tid) {
		return $this->_delete($tid);
	}

	/**
	 * ɾӾϢ
	 *
	 * @param array $tids
	 * @return boolean
	 */
	public function batchDeleteThread($tids) {
		return $this->_batchDelete($tids);
	}

	/**
	 * Ӧķ
	 *
	 * @param array $fields
	 * @return array
	 */
	private function _processField($fields) {
		if (isset($fields['fid'])) {
			$fields['cid'] = $fields['fid'] ? Wekit::load('forum.srv.PwForumService')->getCateId($fields['fid']) : 0;
		}
		return $fields;
	}
	
	/**
	 * ֶκ
	 *
	 * @param string $order
	 * @param boolean $fid
	 * @return array
	 */
	private function _getOrderFieldAndIndex($order, $fid = false) {
		if ($order == 'lastpost') {
			return array('lastpost_time', false === $fid ? 'idx_cid_lastposttime' : 'idx_fid_lastposttime_topictype');
		}
		return array('tid', 'PRIMARY');
	}
}