<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * ӷ
 *
 * -> 1.check ӷл
 * -> 2.appendDo(*) ӷʱΪ,:ͶƱ(ѡ)
 * -> 3.execute 
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwPost.php 28950 2013-05-31 05:58:25Z jieyin $
 * @package forum
 */
class PwPost extends PwBaseHookService {

	public $action;
	public $forum;
	public $user;
	public $special; // 

	public function __construct(PwPostAction $action) {
		$this->action = $action;
		$this->forum = $action->forum;
		$this->user = $action->user;
		$this->special = $action->getSpecial();
		
		/** hook **/
		$this->action->setSrv($this);
	}

	/**
	 * ֮ǰ
	 *
	 * @return bool
	 */
	public function check() {
		if (($result = $this->isInit()) !== true) {
			return new PwError('data.error');
		}
		if (($result = $this->checkForum()) !== true) {
			return $result;
		}
		if (($result = $this->checkPost()) !== true) {
			return $result;
		}
		if ($this->isBan()) {
			return new PwError('ban');
		}
		if (($result = $this->action->check()) !== true) {
			return $result;
		}
		return true;
	}

	/**
	 * ʼϢǷҪ
	 *
	 * @return bool
	 */
	public function isInit() {
		return $this->action->isInit();
	}

	/**
	 * ǷӵиðȨ
	 *
	 * @return bool
	 */
	public function checkForum() {
		if (!$this->forum->isForum()) {
			return new PwError('BBS:post.forum.not.exists');
		}
		if (($result = $this->forum->allowVisit($this->user)) !== true) {
			return new PwError('BBS:forum.permissions.visit.allow', 
				array('{grouptitle}' => $this->user->getGroupInfo('name')));
		}
		return true;
	}

	/**
	 * Ƿ
	 *
	 * @return bool
	 */
	public function checkPost() {
		if ($this->user->groupid == 7) {
			return new PwError('REG_CHECK');
		}
		/*
		$config = Wekit::C('bbs');
		if ($config['post.timing.open'] && !$this->user->inGroup($config['post.timing.groups']) && !self::inTime($config['post.timing.start_hour'], $config['post.timing.start_min'], $config['post.timing.end_hour'], $config['post.timing.end_min'])) {
			return new PwError('BBS:post.timing');
		}
		*/
		return true;
	}

	/**
	 * ûǷ񱻽
	 *
	 * @return bool
	 */
	public function isBan() {
		if ($this->user->gid == 6) {
			Wind::import('SRV:user.srv.PwBanBp');
			$banBp = new PwBanBp($this->user->uid);
			$memberid = 0;
			if (false === $banBp->checkIfBanSpeak()) {
				$memberid = $banBp->recoveryBanSpeaKError();
			} elseif ($banBp->endDateTimeBanSpeak()) {
				$memberid = $banBp->callEndDateTimeBanSpeak();
			}
			if ($memberid) {
				$this->user->info['groups'] = '';
				$this->user->info['groupid'] = 0;
				$this->user->info['memberid'] = $memberid;
				$this->user->groups = array($memberid);
				$this->user->resetGid($memberid);
				return false;
			}
			return true;
		}
		return false;
	}

	public function getDm() {
		return $this->action->getDm();
	}

	/**
	 * ӦûȡûdmãԴﵽûϢĿ
	 *
	 * @return object PwUserInfoDm
	 */
	public function getUserDm() {
		return $this->action->getUserDm();
	}

	public function getAttachs() {
		return $this->action->getAttachs();
	}

	/**
	 * 
	 *
	 * @param object $postDm ģ
	 * @return bool
	 */
	public function execute(PwPostDm $postDm) {
		if (($result = $this->action->beforeRun($postDm)) instanceof PwError) {
			return $result;
		}
		if (($result = $this->action->dataProcessing($postDm)) !== true) {
			return $result;
		}
		if (($result = $this->action->execute()) !== true) {
			return $result;
		}
		$this->action->afterRun();
		$this->updateUser();
		return true;
	}

	public function getInfo() {
		return $this->action->getInfo();
	}

	public function getNewId() {
		return $this->action->getNewId();
	}

	public function getDisabled() {
		return $this->action->isDisabled();
	}

	/**
	 * ûϢ ///
	 */
	public function updateUser() {
		Wind::import('SRV:credit.bo.PwCreditBo');
		$credit = PwCreditBo::getInstance();
		if ($operation = $this->action->getCreditOperate()) {
			$credit->operate($operation, $this->user, true, 
				array('forumname' => $this->forum->foruminfo['name']), 
				$this->forum->getCreditSet($operation));
		}
		$credit->execute();
		$this->action->updateUser();
		if ($userDm = $this->action->getUserDm(false)) {
			Wekit::load('user.PwUser')->editUser($userDm, PwUser::FETCH_DATA);
		}
	}

	public function appendDo($do) {
		$this->action->appendDo($do);
	}
	
	public function runDo($method) {
		$args = func_get_args();
		call_user_func_array(array($this->action, 'runDo'), $args);
	}

	public function getHookKey() {
		return $this->action->getHookKey();
	}

	/**
	 * жϵǰʱ䣬Ƿʱ
	 *
	 * @param int $startHour ʼʱ/Сʱ
	 * @param int $startMin ʼʱ/
	 * @param int $endHour ʱ/Сʱ
	 * @param int $endMin ʱ/
	 * @return bool
	 */
	public static function inTime($startHour, $startMin, $endHour, $endMin) {
		list($currentHour, $currentMin) = explode(':', Pw::time2str(Pw::getTime(), 'H:i'));
		$startTime = self::times($startHour, $startMin);
		$endTime = self::times($endHour, $endMin);
		$currentTime = self::times($currentHour, $currentMin);
		if ($startTime == $endTime && $currentTime != $startTime) {
			return false;
		}
		if ($startTime < $endTime && $currentTime < $startTime || $currentTime > $endTime) {
			return false;
		}
		if ($startTime > $endTime && $currentTime > $endTime && $currentTime < $startTime) {
			return false;
		}
		return true;
	}

	public static function times($hour, $min) {
		return $hour * 60 + $min;
	}
	
	/* (non-PHPdoc)
	 * @see PwBaseHookService::_getInterfaceName()
	 */
	protected function _getInterfaceName() {
		return '';
	}
}