<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * ʾб
 *
 * -> 1.check ʾл
 * -> 2.appendDo(*) ʾʱΪ,:ͶƱ͵(ѡ)
 * -> 3.execute ׼
 * -> 4.get... ȡҳʾҪ
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwThreadList.php 24045 2013-01-21 05:34:56Z jieyin $
 * @package forum
 */

class PwThreadList extends PwBaseHookService {

	public $page = 1;
	public $perpage = 20;
	public $total = 0;
	public $maxPage;

	public $icon;
	public $uploadIcon;
	public $specialIcon;

	protected $_iconNew;
	protected $_iconHot;
	protected $_maxPage;
	protected $_ds;

	public function __construct() {
		parent::__construct();
		$this->icon = array(
			'headtopic_3' => 'ö3',
			'headtopic_2' => 'ö2',
			'headtopic_1' => 'ö1',
			'digest' => '',
			'lock' => '',

			'vote' => 'ͶƱ',
			'reward' => '',
			'shop' => 'Ʒ',
			'debate' => '',
			'active' => '',

			'topichot' => '',
			'topicnew' => '',
			'topic' => 'ͨ',

			'img' => 'ͼƬ',
			'file' => '',
			'music' => '',
			'like' => 'ϲ',
		);
		$this->uploadIcon = array(
			1 => 'img', 2 => 'txt', 3 => 'img', 4 => 'file', 5 => 'img', 6 => 'txt', 7 => 'img'
		);
		$this->specialIcon = array(
			'poll' => 'vote'
		);
		$this->_iconNew = Wekit::C('bbs', 'thread.new_thread_minutes') * 60;
		$this->_iconHot = Wekit::C('bbs', 'thread.hotthread_replies');
		$this->_maxPage = Wekit::C('bbs', 'thread.max_pages');
	}

	public function setPage($page) {
		$this->page = intval($page);
		return $this;
	}

	public function setPerpage($perpage) {
		$perpage = intval($perpage);
		$perpage > 0 && $this->perpage = $perpage;
		return $this;
	}

	public function setIconNew($time) {
		$time && $this->_iconNew = $time * 60;
		return $this;
	}

	public function execute(PwThreadDataSource $ds) {
		$this->_ds = $ds;
		$this->total = $ds->getTotal();
		$this->maxPage = ceil($this->total / $this->perpage);
		$this->_maxPage > 0 && $this->maxPage = min($this->maxPage, $this->_maxPage);
		$this->page < 1 && $this->page = 1;
		$this->page > $this->maxPage && $this->page = $this->maxPage;
		list($start, $limit) = Pw::page2limit($this->page, $this->perpage);

		$threaddb = $ds->getData($limit, $start);
		$this->runDo('initData', $threaddb);

		foreach ($threaddb as $key => $value) {
			$threaddb[$key] = $this->bulidThread($value);
		}
		$this->threaddb = $threaddb;
	}
	
	public function bulidThread($thread) {
		if ($thread['issort'] && $thread['topped']) {
			$thread['icon'] = 'headtopic_' . $thread['topped'];
		} elseif ($thread['digest']) {
			$thread['icon'] = 'digest';
		} elseif (Pw::getstatus($thread['tpcstatus'], PwThread::STATUS_LOCKED)) {
			$thread['icon'] = 'lock';
		} elseif ($thread['special'] && isset($this->specialIcon[$thread['special']])) {
			$thread['icon'] = $this->specialIcon[$thread['special']];
		} elseif ($thread['replies'] > $this->_iconHot) {
			$thread['icon'] = 'topichot';
		} elseif (Pw::getTime() - $thread['created_time'] < $this->_iconNew) {
			$thread['icon'] = 'topicnew';
		} else {
			$thread['icon'] = 'topic';
		}
		if ($thread['overtime'] && $thread['overtime'] < Pw::getTime()) {
			$overtimeService = Wekit::load("SRV:forum.srv.PwOvertimeService");
			$overtimeService->updateOvertime($thread['tid']);
		}
		if ($thread['highlight']) {
			$highlight = Wekit::load("Lib:utility.PwHighlight");
			$thread['highlight_style'] = $highlight->getStyle($thread['highlight']);
		}
		if ($thread['inspect']) {
			$thread['inspect'] = explode("\t", $thread['inspect']);
		}
		if ($thread['ifshield']) {
			$thread['highlight_style'] = 'text-decoration: line-through';
			$thread['subject'] = 'ѱ';
		}
		return $this->runWithFilters('bulidThread', $thread);
	}

	public function getList() {
		return $this->threaddb;
	}

	public function getUrlArgs() {
		return $this->_ds->getUrlArgs();
	}

	protected function _getInterfaceName() {
		return 'PwThreadListDoBase';
	}
}