<?php
defined('WEKIT_VERSION') || exit('Forbidden');

class PwTopicTypeService {

	/**
	 * ʾ(бҳ)
	 * 
	 * @param $type
	 * @param array $topictypes
	 * @return array
	 */
	public function sortTopictype($type, $topictypes) {
		$parentid = $topictypes['all_types'][$type]['parentid'];
		$current = $topictypes['all_types'][$type];
		if ($parentid) {
			//ѡӷ 
			$tmp_topic_types = $tmp_sub_topic_types = array();
			//ѡеӷб
			$tmp_sub_topic_types[$parentid] = $topictypes['all_types'][$parentid];
			foreach ($topictypes['sub_topic_types'][$parentid] as $k => $v) {
				if ($k == $type) {
					continue;
				}
				$tmp_sub_topic_types[$k] = $v;
			}
			//Ƴѡеһ·б
			unset($topictypes['sub_topic_types'][$parentid]);
			$topictypes['sub_topic_types'][$current['id']] = $tmp_sub_topic_types;
			//add sub to top level
			foreach ($topictypes['topic_types'] as $k => $v) {
				if ($k == $parentid) {
					$tmp_topic_types[$current['id']] = $current;
				} else {
					$tmp_topic_types[$k] = $v;
				}
			}
			//µһ
			$topictypes['topic_types'] = $tmp_topic_types;
		}
		return $topictypes;
	}
	
	public function getTopictypes($fid) {
		$data = $this->_getTopictypeDs()->getTypesByFid($fid);
		if (!$data) return array();
		$topicTypes = array();
		foreach ($data as $k => $v) {
			if ($v['parentid'] > 0){
				$topicTypes[$v['parentid']]['sub_type'][$k]['name'] = $v['name'];
			} else {
				$tmp['name'] = $v['name'];
				$topicTypes[$k] = $tmp;
			}
		}
		return $topicTypes;
	}
	
	/**
	 * A鸴B
	 * 
	 * @param int $fromFid
	 * @param int $toFid
	 */
	public function copyTopicType($fromFid,$toFid){
		$this->_getTopictypeDs()->deleteTopicTypeByFid($toFid);
		$topicTypes = $this->_getTopictypeDs()->getTypesByFid($fromFid);
		$idMap = $subTopicTypes = array();
		Wind::import('SRV:forum.dm.PwTopicTypeDm');
		foreach ($topicTypes as $k=>$v) {
			if ($v['parentid']) {
				$subTopicTypes[$k] = $v;
				continue;
			}
			$dm = new PwTopicTypeDm();
			$dm->setFid($toFid)
				->setIsSystem($v['issys'])
				->setVieworder($v['vieworder'])
				->setLogo($v['logo'])
				->setName($v['name']);
			$id = $this->_getTopictypeDs()->addTopicType($dm);
			$idMap[$v['id']] = $id;
		}
		if ($subTopicTypes) {
			foreach ($subTopicTypes as $k=>$v) {
				$dm = new PwTopicTypeDm();
				$dm->setFid($toFid)
					->setIsSystem($v['issys'])
					->setVieworder($v['vieworder'])
					->setLogo($v['logo'])
					->setName($v['name'])
					->setParentId($idMap[$v['parentid']]);
				$this->_getTopictypeDs()->addTopicType($dm);
			}
		}
		return true;
	}
	
	/**
	 * Enter description here ...
	 * 
	 * @return PwTopicType
	 */
	private function _getTopictypeDs(){
		return Wekit::load('forum.PwTopicType');
	}
}