<?php

Wind::import('SRV:forum.srv.manage.PwThreadManageDo');
Wind::import('SRV:forum.dm.PwTopicDm');

/**
 * ӹ-
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwThreadManageDoDigest.php 14445 2012-07-20 09:16:44Z jinlong.panjl $
 * @package forum
 */

class PwThreadManageDoType extends PwThreadManageDo {
	

	protected $tids;
	protected $isDeductCredit = true;
	protected $topictype = 0;
	protected $subTopicType = 0;
	protected $threadsInfo;
	protected $submit = false;
	
	/**
	 * Enter description here ...
	 *
	 * @param PwThreadManage $srv
	 */
	public function __construct(PwThreadManage $srv){
		parent::__construct($srv);
		$this->threadsInfo = $srv->data;
	}
	
	/* (non-PHPdoc)
	 * @see PwThreadManageDo::check()
	 */
	public function check($permission) {
		if (!isset($permission['type']) || !$permission['type']) {
			return false;
		}
		return $this->checkTopicType();
	}

	/* (non-PHPdoc)
	 * @see PwThreadManageDo::gleanData()
	 */
	public function gleanData($value) {
		$this->tids[] = $value['tid'];
	}
	
	/**
	 * һ
	 *
	 * @param int $topictype
	 * @return PwThreadManageDoType
	 */
	public function setTopictype($topictype, $subTopicType = '') {
		$this->topictype = intval($topictype);
		$this->subTopicType = intval($subTopicType);
		$this->submit = true;
		return $this;
	}
	
	/**
	 *	ñ
	 *
	 *  @return array
	 */
	public function getTopicTypes(){
		$forumset = $this->_getForum();
		return Wekit::load('forum.srv.PwTopicTypeService')->getTopictypes($forumset['fid']);
	}
	
	/* (non-PHPdoc)
	 * @see PwThreadManageDo::run()
	 */
	public function run() {
		$topicDm = new PwTopicDm(true);
		$topicDm->setTopictype($this->topictype);
		$this->_getThreadDs()->batchUpdateThread($this->tids, $topicDm, PwThread::FETCH_MAIN);

		//־

		Wekit::load('log.srv.PwLogService')->addThreadManageLog($this->srv->user, 'type', $this->threadsInfo, $this->_reason, $this->topictype);
	}
	
	/**
	 * Enter description here ...
	 *
	 * @return PwError|boolean|Ambigous <number, unknown>
	 */
	private function _getForum(){
		$fid = 0;
		foreach ($this->threadsInfo as $v) {
			if ($fid && $v['fid'] != $fid) return new PwError('MANAGE.multiple_forums_typed');
			$fid = $v['fid'];
		}
		if (!$fid) return true;
		$forum = $this->_getForumDS()->getForum($fid,PwForum::FETCH_EXTRA);
		$forumset = unserialize($forum['settings_basic']);
		$forumset['fid'] = $fid;
		return $forumset;
	}
	
	/**
	 * 
	 *
	 * @return PwError|boolean
	 */
	private function checkTopicType() {
		if (!$this->submit) return true;
		$forumset = $this->_getForum();
		$topicTypes = $this->getTopicTypes();
		if ($this->topictype && !$forumset['topic_type']) {
			return new PwError('BBS:post.topictype.closed');
		}
		if ($forumset['topic_type'] && $forumset['force_topic_type'] && !$this->topictype && $topicTypes) {
			return new PwError('BBS:post.topictype.empty');
		}
		//һ࣬һ಻ڣ򱨴
		//õһڵ£Ҳ˶࣬ҶһιϵڣûΪöID
		if (!array_key_exists($this->topictype, $topicTypes)) {
			return new PwError('BBS:post.topictype.error');
		} elseif ($this->subTopicType && array_key_exists($this->subTopicType, $topicTypes[$this->topictype]['sub_type'])) {
			$this->topictype = $this->subTopicType;
		}
		return true;
	}
	
	/**
	 * ӴDS
	 *
	 * @return PwThread
	 */
	public function _getThreadDs() {
		return Wekit::load('forum.PwThread');
	}
	
	/**
	 * DM 
	 * 
	 * @return PwForum
	 */
	private function _getForumDS(){
		return Wekit::load('forum.PwForum');
	}
}