<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('LIB:process.PwGleanDoProcess');
Wind::import('HOOK:PwDeleteReply.PwDeleteReplyDoVirtualDelete');
Wind::import('HOOK:PwDeleteReply.PwDeleteReplyDoDirectDelete');
Wind::import('HOOK:PwDeleteReply.PwDeleteReplyDoFreshDelete');
Wind::import('HOOK:PwDeleteReply.PwDeleteReplyDoAttachDelete');
Wind::import('HOOK:PwDeleteReply.PwDeleteReplyDoPostUpdate');
Wind::import('HOOK:PwDeleteReply.PwDeleteReplyDoForumUpdate');
Wind::import('HOOK:PwDeleteReply.PwDeleteReplyDoUserUpdate');
Wind::import('HOOK:PwDeleteReply.PwDeleteReplyDoToppedDelete');

/**
 * ɾӼ(չ)
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwDeleteReply.php 23356 2013-01-09 03:20:51Z jieyin $
 * @package forum
 */

class PwDeleteReply extends PwGleanDoProcess {
	
	public $data = array();
	public $pids = array();
	public $user;

	public $isRecycle = false;
	public $isDeductCredit = false;
	public $isDeleteFresh = true;
	public $reason;
	
	public function __construct(iPwDataSource $ds, PwUserBo $user) {
		$this->data = $this->_bulidData($ds->getData());
		$this->user = $user;
		parent::__construct();
	}
	
	/**
	 * setting - Ƿɾվ
	 *
	 * @param bool $recycle Ƿɾվ
	 * @return object $this
	 */
	public function setRecycle($recycle) {
		$this->isRecycle = $recycle;
		return $this;
	}
	
	/**
	 * setting - Ƿ۳
	 *
	 * @param bool $isDeductCredit Ƿ۳
	 * @return object $this
	 */
	public function setIsDeductCredit($isDeductCredit) {
		$this->isDeductCredit = $isDeductCredit;
		return $this;
	}

	/**
	 * setting - Ƿͬɾ
	 *
	 * @param bool $isDeleteFresh Ƿͬɾ
	 * @return object $this
	 */
	public function setIsDeleteFresh($isDeleteFresh) {
		$this->isDeleteFresh = $isDeleteFresh;
		return $this;
	}

	/**
	 * setting - ɾ
	 *
	 * @param string $reason
	 * @return object $this
	 */
	public function setReason($reason) {
		$this->reason = $reason;
		return $this;
	}

	public function getData() {
		return $this->data;
	}

	public function getIds() {
		return $this->pids;
	}

	protected function init() {
		if ($this->isRecycle) {
			$this->appendDo(new PwDeleteReplyDoVirtualDelete($this));
		} else {
			$this->appendDo(new PwDeleteReplyDoDirectDelete($this));
		}
		
		$this->appendDo(new PwDeleteReplyDoUserUpdate($this));
		if ($this->isDeleteFresh) {
			$this->appendDo(new PwDeleteReplyDoFreshDelete($this));
		}
		$this->appendDo(new PwDeleteReplyDoAttachDelete($this));
		$this->appendDo(new PwDeleteReplyDoPostUpdate($this));
		$this->appendDo(new PwDeleteReplyDoForumUpdate($this));
		$this->appendDo(new PwDeleteReplyDoToppedDelete($this));
	}

	protected function gleanData($value) {
		$this->pids[] = $value['pid'];
	}

	protected function _bulidData($data) {
		$pids = array_keys($data);
		$result = Wekit::load('recycle.PwReplyRecycle')->fetchRecord($pids);
		foreach ($data as $key => $value) {
			$value['from_tid'] = isset($result[$key]) ? $result[$key]['tid'] : $value['tid'];
			$data[$key] = $value;
		}
		return $data;
	}

	protected function run() {
		return true;
	}
}