<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('LIB:process.PwGleanDoProcess');
Wind::import('HOOK:PwDeleteTopic.PwDeleteTopicDoVirtualDelete');
Wind::import('HOOK:PwDeleteTopic.PwDeleteTopicDoDirectDelete');
Wind::import('HOOK:PwDeleteTopic.PwDeleteArticleDoAttachDelete');
Wind::import('HOOK:PwDeleteTopic.PwDeleteArticleDoForumUpdate');
Wind::import('HOOK:PwDeleteTopic.PwDeleteTopicDoUserUpdate');
Wind::import('HOOK:PwDeleteTopic.PwDeleteTopicDoFreshDelete');
Wind::import('HOOK:PwDeleteTopic.PwDeleteTopicDoSpecialDelete');
Wind::import('HOOK:PwDeleteTopic.PwDeleteTopicDoTagDelete');
Wind::import('HOOK:PwDeleteTopic.PwDeleteTopicDoPollDelete');
Wind::import('HOOK:PwDeleteTopic.PwDeleteTopicDoDigestDelete');

/**
 * ɾӼ(չ)
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwDeleteTopic.php 17512 2012-09-06 04:50:49Z xiaoxia.xuxx $
 * @package forum
 */

class PwDeleteTopic extends PwGleanDoProcess {
	
	public $data = array();
	public $tids = array();
	public $user;

	public $isRecycle = false;
	public $isDeductCredit = false;
	public $isDeleteFresh = true;
	public $reason;
	
	public function __construct(iPwDataSource $ds, PwUserBo $user) {
		$this->data = $ds->getData();
		$this->user = $user;
		parent::__construct();
	}
	
	/**
	 * setting - Ƿɾվ
	 *
	 * @param bool $recycle Ƿɾվ
	 * @return object $this
	 */
	public function setRecycle($recycle) {
		$this->isRecycle = $recycle;
		return $this;
	}
	
	/**
	 * setting - Ƿ۳
	 *
	 * @param bool $isDeductCredit Ƿ۳
	 * @return object $this
	 */
	public function setIsDeductCredit($isDeductCredit) {
		$this->isDeductCredit = $isDeductCredit;
		return $this;
	}

	/**
	 * setting - Ƿͬɾ
	 *
	 * @param bool $isDeleteFresh Ƿͬɾ
	 * @return object $this
	 */
	public function setIsDeleteFresh($isDeleteFresh) {
		$this->isDeleteFresh = $isDeleteFresh;
		return $this;
	}
	
	/**
	 * setting - ɾ
	 *
	 * @param string $reason
	 * @return object $this
	 */
	public function setReason($reason) {
		$this->reason = $reason;
		return $this;
	}

	public function getData() {
		return $this->data;
	}

	protected function init() {
		if ($this->isRecycle) {
			$this->appendDo(new PwDeleteTopicDoVirtualDelete($this));
		} else {
			$this->appendDo(new PwDeleteTopicDoDirectDelete($this));
		}

		if ($this->isDeleteFresh) {
			$this->appendDo(new PwDeleteTopicDoFreshDelete($this));
		}
		//change: when delete topic then user's data about thread like postnum digests while be updated rather than credit
		$this->appendDo(new PwDeleteTopicDoUserUpdate($this));
		$this->appendDo(new PwDeleteArticleDoAttachDelete($this));
		$this->appendDo(new PwDeleteArticleDoForumUpdate($this));
		$this->appendDo(new PwDeleteTopicDoSpecialDelete($this));
		$this->appendDo(new PwDeleteTopicDoTagDelete($this));
		$this->appendDo(new PwDeleteTopicDoPollDelete($this));
		$this->appendDo(new PwDeleteTopicDoDigestDelete($this));
	}

	protected function gleanData($value) {
		$this->tids[] = $value['tid'];
	}

	public function getIds() {
		return $this->tids;
	}

	protected function run() {
		return true;
	}
}