<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * ظ
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwPostSo.php 13278 2012-07-05 02:08:39Z jieyin $
 * @package forum
 */

class PwPostSo {
	
	protected $_data = array();
	protected $_orderby = array();

	public function getData() {
		return $this->_data;
	}
	
	public function getOrderby() {
		return $this->_orderby;
	}

	/**
	 * ظ
	 */
	public function setKeywordOfTitle($keyword) {
		$this->_data['title_keyword'] = $keyword;
		return $this;
	}
	
	/**
	 * ظ
	 */
	public function setKeywordOfContent($keyword) {
		$this->_data['content_keyword'] = $keyword;
		return $this;
	}
	
	/**
	 * ظ
	 */
	public function setKeywordOfTitleOrContent($keyword) {
		$this->_data['title_and_content_keyword'] = $keyword;
		return $this;
	}

	/**
	 * Ƿ
	 */
	public function setDisabled($disabled) {
		$this->_data['disabled'] = $disabled;
		return $this;
	}

	/**
	 * 
	 *
	 * @param mixed $fid  int|array
	 */
	public function setFid($fid) {
		$this->_data['fid'] = $fid;
		return $this;
	}

	/**
	 * 
	 *
	 * @param mixed $tid  int|array
	 */
	public function setTid($tid) {
		$this->_data['tid'] = $tid;
		return $this;
	}
	
	/**
	 * 
	 */
	public function setAuthor($author) {
		$user = Wekit::load('user.PwUser')->getUserByName($author);
		$this->setAuthorId($user ? $user['uid'] : 0);
		return $this;
	}

	/**
	 * 
	 *
	 * @param mixed $authorid  int|array
	 */
	public function setAuthorId($authorid) {
		$this->_data['created_userid'] = $authorid;
		return $this;
	}
	
	/**
	 * ʱ䣬ʼ
	 */
	public function setCreateTimeStart($time) {
		$this->_data['created_time_start'] = $time;
		return $this;
	}
	
	/**
	 * ʱ䣬
	 */
	public function setCreateTimeEnd($time) {
		$this->_data['created_time_end'] = $time + 86400;
		return $this;
	}

	public function setCreatedIp($ip) {
		$this->_data['created_ip'] = $ip;
		return $this;
	}

	public function orderbyCreatedTime($asc) {
		$this->_orderby['created_time'] = (bool)$asc;
		return $this;
	}
}