<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * 
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwThreadSo.php 19582 2012-10-16 05:41:16Z jieyin $
 * @package forum
 */

class PwThreadSo {
	
	protected $_data = array();
	protected $_orderby = array();

	public function getData() {
		return $this->_data;
	}

	public function getOrderby() {
		return $this->_orderby;
	}
	
	/**
	 * tid
	 */
	public function setTid($tid) {
		$this->_data['tid'] = $tid;
		return $this;
	}
	
	/**
	 * ӱ
	 */
	public function setKeywordOfTitle($keyword) {
		$this->_data['title_keyword'] = $keyword;
		return $this;
	}
	
	/**
	 * 
	 */
	public function setKeywordOfContent($keyword) {
		$this->_data['content_keyword'] = $keyword;
		return $this;
	}
	
	/**
	 * ӱ
	 */
	public function setKeywordOfTitleOrContent($keyword) {
		$this->_data['title_and_content_keyword'] = $keyword;
		return $this;
	}
	
	/**
	 * Ƿ
	 */
	public function setDisabled($disabled) {
		$this->_data['disabled'] = $disabled;
		return $this;
	}

	/**
	 * 
	 */
	public function setFid($fid) {
		$this->_data['fid'] = $fid;
		return $this;
	}	
	
	/**
	 * 
	 */
	public function setTopicType($type) {
		$this->_data['topic_type'] = $type;
		return $this;
	}
	
	/**
	 * 
	 */
	public function setAuthor($authors) {
		if (!is_array($authors)) {
			$authors = array($authors);
		} 
		$users = Wekit::load('user.PwUser')->fetchUserByName($authors);
		$this->setAuthorId(array_keys($users));
		return $this;
	}

	/**
	 * id
	 */
	public function setAuthorId($authorid) {
		if (!$authorid) $authorid = array(0);
		$this->_data['created_userid'] = $authorid;
		return $this;
	}
	
	/**
	 * 
	 */
	public function setSpecial($special) {
		$this->_data['special'] = $special;
		return $this;
	}
	
	/**
	 * ö
	 */
	public function setTopped($topped) {
		$this->_data['topped'] = $topped;
		return $this;
	}
	
	/**
	 * Ƿ񾫻
	 */
	public function setDigest($digest) {
		$this->_data['digest'] = intval($digest);
		return $this;
	}
	
	/**
	 * ǷͼƬ
	 */
	public function setHasImage($bool) {
		$this->_data['hasimage'] = $bool ? 1 : 0;
		return $this;
	}
	
	/**
	 * 䣬ʼ
	 */
	public function setHitsStart($hits) {
		$this->_data['hits_start'] = $hits;
		return $this;
	}
	
	/**
	 * 䣬
	 */
	public function setHitsEnd($hits) {
		$this->_data['hits_end'] = $hits;
		return $this;
	}
	
	/**
	 * ظ䣬ʼ
	 */
	public function setRepliesStart($replies) {
		$this->_data['replies_start'] = $replies;
		return $this;
	}
	
	/**
	 * ظ䣬
	 */
	public function setRepliesEnd($replies) {
		$this->_data['replies_end'] = $replies;
		return $this;
	}

	public function setCreatedIp($ip) {
		$this->_data['created_ip'] = $ip;
		return $this;
	}
	
	/**
	 * ʱ䣬ʼ
	 */
	public function setCreateTimeStart($time) {
		$this->_data['created_time_start'] = $time;
		return $this;
	}
	
	/**
	 * ʱ䣬
	 */
	public function setCreateTimeEnd($time) {
		$this->_data['created_time_end'] = $time + 86400;
		return $this;
	}
	
	/**
	 * ظʱ䣬ʼ
	 */
	public function setLastpostTimeStart($start) {
		$this->_data['lastpost_time_start'] = $start;
		return $this;
	}
	
	/**
	 * ظʱ䣬
	 */
	public function setLastpostTimeEnd($end) {
		$this->_data['lastpost_time_end'] = $end;
		return $this;
	}

	/**
	 * ʱ
	 */
	public function orderbyCreatedTime($asc) {
		$this->_orderby['created_time'] = (bool)$asc;
		return $this;
	}
	
	/**
	 * ظʱ
	 */
	public function orderbyLastPostTime($asc) {
		$this->_orderby['lastpost_time'] = (bool)$asc;
		return $this;
	}
	
	/**
	 * ظ
	 */
	public function orderbyReplies($asc) {
		$this->_orderby['replies'] = (bool)$asc;
		return $this;
	}
	
	/**
	 * 
	 */
	public function orderbyHits($asc) {
		$this->_orderby['hits'] = (bool)$asc;
		return $this;
	}
	
	/**
	 * ϲ
	 */
	public function orderbyLike($asc) {
		$this->_orderby['like'] = (bool)$asc;
		return $this;
	}
}