<?php

/**
 * DS
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwInviteCode.php 19073 2012-10-10 08:33:40Z xiaoxia.xuxx $
 * @package service.invite
 */
class PwInviteCode {

	/**
	 * Ϣ
	 *
	 * @param string $code
	 * @return array
	 */
	public function getCode($code) {
		if (!$code) return array();
		return $this->_getDao()->getCode($code);
	}
	
	/**
	 * ݴIDʹõб
	 *
	 * @param int $createdUid
	 * @return array
	 */
	public function getUsedCodeByCreatedUid($createdUid, $limit = 18, $start = 0) {
		if (!$createdUid) return array();
		return $this->_getDao()->getUsedCodeByCreatedUid($createdUid, $limit, $start);
	}
	
	/**
	 * ûIDͳƸû
	 *
	 * @param int $createdUid
	 * @return array
	 */
	public function countUsedCodeByCreatedUid($createdUid) {
		if (!$createdUid) return 0;
		return $this->_getDao()->countUsedCodeByCreatedUid($createdUid);
	}
	
	/**
	 * 
	 *
	 * @param PwInviteCodeSo $condition 
	 * @param int $limit 
	 * @param int $offset Ŀʼλ
	 * @return array
	 */
	public function searchCode(PwInviteCodeSo $condition, $limit = 10, $offset = 0) {
		return $this->_getDao()->searchCode($condition->getData(), $limit, $offset);
	}
	
	/**
	 * ͳ
	 *
	 * @param PwInviteCodeSo $condition
	 * @return int
	 */
	public function countSearchCode(PwInviteCodeSo $condition) {
		return $this->_getDao()->countSearchCode($condition->getData());
	}
	
	/**
	 * ûIDʱ䣬ѯûڸʱ֮Ѿ
	 *
	 * @param int $uid ûID
	 * @param int $time ʵʱ
	 * @return int
	 */
	public function countByUidAndTime($uid, $time) {
		return $this->_getDao()->countByUidAndTime($uid, $time);
	}
	
	/**
	 * 
	 *
	 * @param PwInviteCodeDm $dm 
	 * @return boolean
	 */
	public function addCode(PwInviteCodeDm $dm) {
		if (($r = $dm->beforeAdd()) instanceof PwError) return $r;
		return $this->_getDao()->addCode($dm->getData());
	}
	
	/**
	 * 
	 *
	 * @param array $codeDms Ϣ
	 * @return boolean
	 */
	public function batchAddCode($codeDms) {
		if (empty($codeDms) || !is_array($codeDms)) return false;
		$data = array();
		foreach ($codeDms as $dm) {
			if (!($dm instanceof PwInviteCodeDm)) return new PwError('USER:invite.data.format.error');
			if (($r = $dm->beforeAdd()) instanceof PwError) return $r;
			$data[] = $dm->getData();
		}
		return $this->_getDao()->batchAddCode($data);
	}
	
	/**
	 * Ϣ
	 *
	 * @param PwInviteCodeDm $dm Ĺ---עûעᣬɹ֮¸Ĺ
	 * @return boolean
	 */
	public function updateCode(PwInviteCodeDm $dm) {
		if (($r = $dm->beforeUpdate()) instanceof PwError) return $r;
		return $this->_getDao()->updateCode($dm->code, $dm->getData());
	}
	
	/**
	 * ɾ
	 *
	 * @param string $code
	 * @return boolean
	 */
	public function deleteCode($code) {
		return $this->_getDao()->deleteCode($code);
	}
	
	/**
	 * ɾ
	 *
	 * @param array $cods
	 * @return boolean
	 */
	public function batchDeleteCode($codes) {
		return $this->_getDao()->batchDeleteCode($codes);
	}
	
	/**
	 * Ѿڵ
	 *
	 * @param array $codes
	 * @return array
	 */
	public function fetchCode($codes) {
		return $this->_getDao()->fetchCode($codes);
	}
	
	/**
	 * DAO
	 *
	 * @return PwInviteCodeDao
	 */
	private function _getDao() {
		return Wekit::loadDao('invite.dao.PwInviteCodeDao');
	}
}