<?php
/**
 * ز
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwInviteFriendService.php 19073 2012-10-10 08:33:40Z xiaoxia.xuxx $
 * @package src.service.inviate.srv
 */
class PwInviteFriendService {
	private $_inviteCodeKey = 'abc@2012';

	/**
	 * עһû
	 *
	 * @param string $inviteCode
	 * @param int $invited_uid
	 * @return boolean|PwError
	 */
	public function inviteRegist($inviteCode, $invited_uid) {
		$aUser = $this->checkInviteCode($inviteCode);
		if (!is_array($aUser)) return $aUser;
		
		$bUser = $this->_getUserDs()->getUserByUid($invited_uid);
		if (!$bUser) return new PwError('USER:invite.friend.code.invitedUid.error');
		
		/* @var $inviteLogDs PwInviteFriendLog */
		/* $inviteLogDs = Wekit::load('invite.PwInviteFriendLog');
		$inviteLogDs->addLog($aUser['uid'], $invited_uid, Pw::getTime()); */
		
		//ɹ߹ע
		/* @var $attentionSrv PwAttentionService */
		$attentionSrv = Wekit::load('attention.srv.PwAttentionService');
		$attentionSrv->addFollow($invited_uid, $aUser['uid']);
// 		$attentionSrv->addFollow($aUser['uid'], $invited_uid);
		
		//ɹӻ
		/* $inviteConfig = Wekit::getConfig('site');
		$credit = array($inviteConfig['invite.friend.credit.type'] => $inviteConfig['invite.friend.credit.num']); */
		/* @var $creditBo PwCreditBo */
		/* $creditBo = PwCreditBo::getInstance();
		$creditBo->addLog('invite_friend', $credit, new PwUserBo($aUser['uid']), array('friendName' => $bUser['username']));
		$creditBo->writeLog(); */
		
		// ɹ--ѵ
// 		PwSimpleHook::getInstance('PwInviteFriendService_invite')->runDo($aUser['uid'], $invited_uid);
		return true;
	}
	
	/**
	 * 
	 *
	 * @param string $inviteCode ӵ
	 * @param int $invited_uid   ûID
	 * @return boolean
	 */
	public function invite($inviteCode, $invited_uid) {
		if (true !== ($result = $this->allowInvite())) return $result;
		$aUser = $this->checkInviteCode($inviteCode);
		if (!is_array($aUser)) return $aUser;
		
		$bUser = $this->_getUserDs()->getUserByUid($invited_uid);
		if (!$bUser) return new PwError('USER:invite.friend.code.invitedUid.error');
		if ($aUser['uid'] == $bUser['uid']) return new PwError('USER:invite.friend.invite.self');
		
		$r = $this->_addFans($aUser, $bUser);
		if (true !== $r) return $r;
		return $aUser;
		
	}
	
	
	/**
	 * Ƿʹ
	 * 
	 * עᣬ׳Ѿעᣬ벻ã
	 * ʹ
	 *
	 * @return PwError|boolean
	 */
	public function allowInvite() {
// 		$invite_config = Wekit::C('site');
// 		if (!$invite_config['invite.friend.isOpen']) return new PwError('USER:invite.friend.code.close');
		if (2 == Wekit::C('register', 'type')) return new PwError('USER:invite.friend.code.dumplic');
		return true;
	}
	
	/**
	 * ǷЧ
	 *
	 * @param string $code
	 * @return PwError|array
	 */
	public function checkInviteCode($code) {
		$uid = $this->parseInviteCode($code);
		$info = $this->_getUserDs()->getUserByUid($uid);
		if (!$info) return new PwError('USER:invite.friend.code.illage');
		return $info;
	}
	
	/**
	 * 
	 *
	 * @param string $code
	 * @return int
	 */
	public function parseInviteCode($code) {
		$uid = intval(substr($code, 0, strlen($code) - 16));
		if ($uid < 1) return 0;
		if ($code != ($uid . substr(md5($uid . $this->_inviteCodeKey), -16))) return 0;
		return $uid;
	}
	
	/**
	 * ûIDû
	 *
	 * @param int $uid
	 * @return string
	 */
	public function createInviteCode($uid) {
		return $uid . substr(md5($uid . $this->_inviteCodeKey), -16);
	}

	/**
	 * Ϊ
	 *
	 * @param array $aUser
	 * @param array $bUser
	 * @return PwError|boolean
	 */
	private function _addFans($aUser, $bUser) {
		/* @var $attentionDs PwAttention */
		$attentionDs = Wekit::load('attention.PwAttention');
		$aFollowedB = $attentionDs->isFollowed($aUser['uid'], $bUser['uid']);
		$bFollowedA = $attentionDs->isFollowed($bUser['uid'], $aUser['uid']);
	
		if ($aFollowedB && $bFollowedA) {
			return new PwError('USER:invite.friend.exists', array('{name}' => $aUser['username']));
		} elseif (!$aFollowedB && !$bFollowedA) {
			//ɹ໥ע
			/* @var $attention PwAttentionService */
			$attention = Wekit::load('attention.srv.PwAttentionService');
			$attention->addFollow($aUser['uid'], $bUser['uid']);
			$attention->addFollow($bUser['uid'], $aUser['uid']);
		} elseif ($aFollowedB) {
			/* @var $attention PwAttentionService */
			$attention = Wekit::load('attention.srv.PwAttentionService');
			$attention->addFollow($bUser['uid'], $aUser['uid']);
		} elseif ($bFollowedA) {
			/* @var $attention PwAttentionService */
			$attention = Wekit::load('attention.srv.PwAttentionService');
			$attention->addFollow($aUser['uid'], $bUser['uid']);
		}
		return true;
	}
	
	/**
	 * ûDS
	 *
	 * @return PwUser
	 */
	private function _getUserDs() {
		return Wekit::load('user.PwUser');
	}
}