<?php
/**
 * the last known user to change this file in the repository  <$LastChangedBy: gao.wanggao $>
 * @author $Author: gao.wanggao $ Foxsee@aliyun.com
 * @copyright ?2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwLikeStatistics.php 8980 2012-05-01 06:22:59Z gao.wanggao $ 
 * @package 
 */
class PwLikeStatistics {
	
	/**
	 * ȡ
	 * 
	 * @param string $signkey
	 */
	public function getLikeStatistics($signkey) {
		return $this->_getLikeStatisticsDao()->getInfo($signkey);
	}
	
	/**
	 * ȡ
	 * 
	 * @param string $signkey
	 * @param int $likeid
	 */
	public function getInfoByLikeid($signkey, $likeid) {
		return $this->_getLikeStatisticsDao()->getInfoByLikeid($signkey, $likeid);
	}
	
	/**
	 * ȡkey
	 * 
	 * @param array $signkeys
	 */
	public function fetchLikeStatistics($signkeys) {
		return $this->_getLikeStatisticsDao()->fetchInfo($signkeys);
	}
	
	/**
	 * ҳȡ
	 * 
	 * @param string $signkey
	 * @param int $start
	 * @param int $limit
	 * @param bool $isthread ڹͻظ
	 */
	public function getInfoList($signkey, $start = 0, $limit = 10, $isthread = false) {
		$start = (int)$start;
		$limit = (int)$limit;
		return $this->_getLikeStatisticsDao()->getInfoList($signkey, $start, $limit, $isthread);
	}
	
	/**
	 * ȡkeyеСͳ
	 * 
	 * @param string $signkey
	 */
	public function getMinInfo($signkey) {
		return $this->_getLikeStatisticsDao()->getMinInfo($signkey);
	}
	
	/**
	 * ͳƸkey
	 * 
	 * @param string $signkey
	 */
	public function countSignkey($signkey) {
		return $this->_getLikeStatisticsDao()->countSignkey($signkey);
	}
	
	/**
	 * 
	 * 
	 * @param PwLikeStatisticsDm $dm
	 */
	public function addInfo(PwLikeStatisticsDm $dm) {
		$data = $dm->getData();
		$info = $this->getInfoByLikeid($data['signkey'], $data['likeid']);
		if ($info) {
			return $this->_getLikeStatisticsDao()->updateInfo($data);
		}else {
			return $this->_getLikeStatisticsDao()->addInfo($data);
		}
	}
	
	/**
	 * ɾ
	 * 
	 * @param string $key
	 */
	public function deleteInfo($key) {
		return $this->_getLikeStatisticsDao()->deleteInfo($key);
	}
	

	private function _getLikeStatisticsDao() {
		return Wekit::loadDao('like.dao.PwLikeStatisticsDao');
	}
}
?>