<?php
/**
 * ӷDAO
 *
 * @author jinlong.panjl <jinlong.panjl@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: codetemplates(windframework_docs_zend_8.0).xml 2781 03:16:28Z yishuo $
 * @package PwLinkTypeDao
 */
class PwLinkTypeDao extends PwBaseDao {
	
	protected $_pk = 'typeid';
	protected $_table = 'link_type';
	protected $_dataStruct = array('typeid','typename','vieworder');
	
	/**
	 * һ
	 * 
	 * @param array $data
	 * @return int
	 */
	public function addLinkType($data) {
		return $this->_add($data);
	}
	
	/**
	 * ɾһ
	 *
	 * @param int $typeId
	 * @return bool
	 */
	public function delete($typeId) {
		return $this->_delete($typeId);
	}
	
	public function update($typeId,$data) {
		return $this->_update($typeId,$data);
	}
	/**
	 * ޸Ķ
	 *
	 * @param array $data
	 * @return int
	 */
	public function updateLinkTypes($data) {
		foreach ($data as $v) {
			if (!$this->_filterStruct($v) || !$v['typeid']) continue;
			$array[] = array($v['typeid'],$v['vieworder'],$v['typename']);
		}
		if (!$array) return false;
		$sql = $this->_bindTable('REPLACE INTO %s (`typeid`,`vieworder`,`typename`) VALUES ') . $this->sqlMulti($array);
		$this->getConnection()->execute($sql);
		return $this->getConnection()->lastInsertId();
	}
	
	/**
	 * ƻȡ
	 *
	 * @param string $typename
	 * @return int
	 */
	public function getByName($typename) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE `typename`=?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getOne(array($typename));
	}
	
	/**
	 * ȡз
	 *
	 * @return int
	 */
	public function getAllTypes() {
		$sql = $this->_bindTable('SELECT * FROM %s ORDER BY `vieworder` ASC');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array(), 'typeid');
	}
	
}