<?php

/**
 * 
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwLinkService.php 28814 2013-05-24 09:31:14Z jieyin $
 * @package src.service.link.srv
 */
class PwLinkService {
	
	/**
	 * IDб,ɾ
	 *
	 * @param array $lids
	 * @return boolean
	 */
	public function batchDelete($lids) {
		$lids = (!is_array($lids) && $lids) ? array($lids) : $lids;
		$this->_getDs()->batchDelRelationsByLid($lids);
		return $this->_getDs()->batchDelete($lids);
	}

	/**
	 * ݷװ
	 *
	 * @param int $typeid
	 * @return int
	 */
	public function getTypesByTypeId($typeid = null) {
		foreach ($this->_getDs()->getByTypeId($typeid) as $value) {
			$lids[] = $value['lid'];
			$types[$value['lid']][] = $value['typeid'];
		}
		return array($lids, $types);
	}

	/**
	 * ȡб
	 *
	 * @param int $typeId
	 * @return array
	 */
	public function getLinksList($typeId = 0) {
		$links = $typeIds = $linksList = array();
		if (!$typeId) {
			$links = $this->_getDs()->getLinks(0, 100);
			$_typeIds = $this->_getDs()->fetchRelationsByLinkid(array_keys($links));
			foreach ($_typeIds as $_relation) {
				$typeIds[$_relation['lid']][] = $_relation['typeid'];
			}
		} else {
			list($lids, $typeIds) = $this->getTypesByTypeId($typeId);
			$links = $this->_getDs()->getLinksByLids($lids);
		}
		
		if (!$links) return array();
		foreach ($links as $key => $value) {
			$value['typeid'] = (array)$typeIds[$value['lid']];
			$linksList[$key] = $value;
		}
		
		return $linksList;
	}

	/**
	 * ȡδб
	 *
	 * @param int $ifcheck 0 δ| 1
	 * @param int $start
	 * @param int $limit
	 * @return array
	 */
	public function getCheckLinksList($start, $limit, $ifcheck) {
		$count = $this->_getDs()->countLinks($ifcheck);
		if (!$count) return array(0, array());
		$links = $this->_getDs()->getLinks($start, $limit, $ifcheck);
		if ($links) {
			$relations = $this->_getDs()->fetchRelationsByLinkid(array_keys($links));
			foreach ($relations as $_item) {
				if (!isset($links[$_item['lid']]['typeids'])) {
					$links[$_item['lid']]['typeids'] = array();
				}
				$links[$_item['lid']]['typeids'][] = $_item['typeid'];
			}
		}
		return array($count, $links);
	}

	/**
	 * ݷʶװlogoͷlogo
	 *
	 * @param string $typename
	 * @return array
	 */
	public function getLinksByType($typename) {
		$type = $this->_getDs()->getTypeByName($typename);
		if (!$type) {
			return array();
		}
		list($lids) = $this->getTypesByTypeId($type['typeid']);
		$linkList = array();
		foreach ($this->_getDs()->getLinksByLids($lids) as $link) {
			if ($link['logo']) {
				$linkList['logo'][] = $link;
				continue;
			}
			$linkList['text'][] = $link;
		}
		return $linkList;
	}

	/**
	 * б
	 *
	 * @return array
	 */
	public function getAllLinkTypes() {
		$linkCount = $this->_getDs()->countLinkTypes();
		$linkTypes = array();
		foreach ($this->_getDs()->getAllTypes() as $k => $v) {
			$v['linknum'] = isset($linkCount[$k]['linknum']) ? $linkCount[$k]['linknum'] : 0;
			$linkTypes[$v['typeid']] = $v;
		}
		return $linkTypes;
	}

	/**
	 * linkDS
	 *
	 * @return PwLink
	 */
	private function _getDs() {
		return Wekit::load('link.PwLink');
	}
}