<?php

/**
 * ǰ̨־DS
 *
 * @author xiaoxia.xu<xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwLog.php 24747 2013-02-20 03:13:43Z jieyin $
 * @package src.service.log
 */
class PwLog {
	
	/**
	 * ͨIDȡøӵĲ¼
	 *
	 * @param int $tid
	 * @param int $pid ӻظID
	 * @param int $limit
	 * @param int $start
	 * @return array
	 */
	public function getLogBytid($tid, $pid, $limit = 10, $start = 0) {
		if (0 >= ($tid = intval($tid))) return array();
		return $this->_getLogDao()->getLogByTid($tid, $pid, $limit, $start);
	}

	public function fetchLogByTid($tids, $typeid) {
		if (empty($tids) || !is_array($tids) || empty($typeid) || !is_array($typeid)) return array();
		return $this->_getLogDao()->fetchLogByTid($tids, $typeid);
	}

	/**
	 * ־
	 *
	 * @param PwLogSo $so
	 * @return array
	 */
	public function search(PwLogSo $so, $limit, $offset) {
		return $this->_getLogDao()->search($so->getCondition(), $limit, $offset);	
	}
	
	/**
	 * ͳ־
	 *
	 * @param PwLogSo $so
	 * @return int
	 */
	public function coutSearch(PwLogSo $so) {
		return $this->_getLogDao()->countSearch($so->getCondition());
	}
	
	/**
	 * ־
	 *
	 * @param PwLogDm $dm
	 * @return int
	 */
	public function addLog(PwLogDm $dm) {
		if (true !== ($r = $dm->beforeAdd())) return $r;
		return $this->_getLogDao()->addLog($dm->getData());
	}
	
	/**
	 * ־
	 *
	 * @param array $dms
	 * @return boolean
	 */
	public function batchAddLog($dms) {
		if (empty($dms)) return true;
		$datas = array();
		foreach ($dms as $_dm) {
			if (!$_dm instanceof PwLogDm) {
				return false;
			}
			if (true !== ($r = $_dm->beforeAdd())) {
				return $r;
			}
			$data[] = $_dm->getData();
		}
		return $this->_getLogDao()->batchAddLog($data);
	}
	
	/**
	 * ־IDɾ־
	 *
	 * @param int $id
	 * @return int
	 */
	public function deleteLog($id) {
		if (0 >= ($id = intval($id))) return false;
		return $this->_getLogDao()->deleteLog($id);
	}
	
	/**
	 * ־IDбɾ־
	 *
	 * @param array $logids
	 * @return int
	 */
	public function batchDeleteLog($logids) {
		if (empty($logids)) return false;
		return $this->_getLogDao()->batchDeleteLog($logids);
	}
	
	/**
	 * ĳһʱ֮ǰļ¼
	 *
	 * @param string $time
	 * @return boolean
	 */
	public function clearLogBeforeDatetime($time) {
		if (!$time) return false;
		return $this->_getLogDao()->clearLogBeforeDatetime($time);
	}
	
	/**
	 * @return PwLogDao
	 */
	protected function _getLogDao() {
		return Wekit::loadDao('log.dao.PwLogDao');
	}
}