<?php

/**
 * ǰ̨¼־ DS
 *
 * @author xiaoxia.xu<xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwLogLogin.php 21359 2012-12-05 08:01:23Z xiaoxia.xuxx $
 * @package src.service.log
 */
class PwLogLogin {
	const ERROR_PWD = 1;//
	const ERROR_SAFEQ = 2;//ȫ⼰𰸴

	/**
	 * ־
	 *
	 * @param PwLogSo $so
	 * @return array
	 */
	public function search(PwLogSo $so, $limit, $offset) {
		return $this->_getLogDao()->search($so->getCondition(), $limit, $offset);	
	}
	
	/**
	 * ͳ־
	 *
	 * @param PwLogSo $so
	 * @return int
	 */
	public function coutSearch(PwLogSo $so) {
		return $this->_getLogDao()->countSearch($so->getCondition());
	}
	
	/**
	 * ־
	 *
	 * @param PwLogLoginDm $dm
	 * @return int
	 */
	public function addLog(PwLogLoginDm $dm) {
		if (true !== ($r = $dm->beforeAdd())) return $r;
		return $this->_getLogDao()->addLog($dm->getData());
	}
	
	/**
	 * ־
	 *
	 * @param array $dms
	 * @return boolean
	 */
	public function batchAddLog($dms) {
		if (empty($dms)) return true;
		$datas = array();
		foreach ($dms as $_dm) {
			if (!$_dm instanceof PwLogLoginDm) {
				return false;
			}
			if (true !== ($r = $_dm->beforeAdd())) {
				return $r;
			}
			$data[] = $_dm->getData();
		}
		return $this->_getLogDao()->batchAddLog($data);
	}
	
	/**
	 * ־IDɾ־
	 *
	 * @param int $id
	 * @return int
	 */
	public function deleteLog($id) {
		if (0 >= ($id = intval($id))) return false;
		return $this->_getLogDao()->deleteLog($id);
	}
	
	/**
	 * ־IDбɾ־
	 *
	 * @param array $logids
	 * @return int
	 */
	public function batchDeleteLog($logids) {
		if (empty($logids)) return false;
		return $this->_getLogDao()->batchDeleteLog($logids);
	}
	
	/**
	 * ĳһʱ֮ǰļ¼
	 *
	 * @param string $time
	 * @return boolean
	 */
	public function clearLogBeforeDatetime($time) {
		if (!$time) return false;
		return $this->_getLogDao()->clearLogBeforeDatetime($time);
	}
	
	/**
	 * @return PwLogLoginDao
	 */
	protected function _getLogDao() {
		return Wekit::loadDao('log.dao.PwLogLoginDao');
	}
}