<?php
Wind::import('SRC:library.base.PwBaseDao');
/**
 * DAO
 *
 * @author $Author: gao.wanggao $ 
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwNavDao.php 24004 2013-01-18 06:18:11Z gao.wanggao $ 
 * @package nav
 */

class PwNavDao extends PwBaseDao {
	protected $_pk = 'navid';
	protected $_table = 'common_nav';
	protected $_dataStruct = array('navid', 'parentid', 'rootid','type', 'sign', 'name', 'style', 'link', 'alt','image', 'target', 'isshow', 'orderid');
	
	/**
	 * IDȡһϢ
	 *
	 * @param int $navId ID
	 * @return array
	 */
	public function getNav($navid) {
		return $this->_get($navid);
	}
	
	/**
	 * ȡϢ
	 *
	 * @param array $navids
	 * @return Ambigous <multitype:, multitype:multitype: Ambigous <multitype:, multitype:unknown , mixed> >
	 */
	public function fetchNav($navids) {
		return $this->_fetch($navids, $this->_pk);
	}
	
	/**
	 * ȡĳ͵б
	 *
	 * @param string $type 
	 * @param int $isShow Ƿʾ
	 * @return array
	 */
	public function getNavByType($type, $isShow) {
		$where = 'WHERE type = ? ';
		$_array = array($type);
		if ($isShow < 2) {
			$where .=' AND isshow = ? ';
			$_array[] = $isShow;
		}
		$sql = $this->_bindSql('SELECT * FROM %s %s ORDER BY rootid ASC,parentid ASC,orderid ASC', $this->getTable(), $where);
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll($_array);
	}
	
	public function getNavBySign($type, $sign) {
		$sql = $this->_bindTable("SELECT *  FROM %s WHERE type = ? AND sign = ? ");
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getOne(array($type,$sign));
	}

	/**
	 * ȡб
	 *
	 * @param string $type 
	 * @return array
	 */
	public function getRootNav($type, $isShow) {
		$where = 'WHERE type = ? AND parentid = 0 ';
		$_array = array($type);
		if ($isShow < 2) {
			$where .= ' AND isshow = ? ';
			$_array[] = $isShow;
		}
		$sql = $this->_bindSql('SELECT * FROM %s %s ORDER BY orderid ASC', $this->getTable(), $where);
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll($_array);
	}
	
	/**
	 * ȡӵб
	 *
	 * @param int $navId ID
	 * @return array
	 */
	public function getChildNav($navId, $isShow) {
		$where = ' WHERE parentid = ? ';
		$_array = array($navId);
		if ($isShow < 2) {
			$where .= ' AND isshow = ? ';
			$_array[] = $isShow;
		}
		$sql = $this->_bindSql('SELECT * FROM %s %s ORDER BY orderid ASC', $this->getTable(), $where);
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll($_array);
	}
	
	/**
	 * ȡ
	 *
	 * @param string $type 
	 * @param int $parentid ID
	 * @return int
	 */
	public function getNavMaxOrder($type = '', $parentid = 0){
		$sql = $this->_bindTable("SELECT MAX(orderid) AS max FROM %s WHERE type = ? AND parentid = ? ");
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getValue(array($type,$parentid));
	}

	/**
	 * һ
	 *
	 * @param array $data
	 * @return int
	 */
	public function addNav($data){
		return $this->_add($data,true);
	}
	/**
	 * ޸һ
	 *
	 * @param array $data
	 * @return bool
	 */
	public function updateNav($navid, $data){
		return $this->_update($navid, $data);
	}

	/**
	 * ɾһ
	 *
	 * @param int $navId
	 * @return bool
	 */
	public function delNav($navid){
		return $this->_delete($navid);
	}
	
}