<?php

 /**
  * ο߷
  * 
  * @author $Author: gao.wanggao $ Foxsee@aliyun.com
  * @copyright 2003-2103 phpwind.com
  * @license http://www.phpwind.com
  * @version $Id: PwGuestOnline.php 17060 2012-08-31 01:50:31Z gao.wanggao $ 
  * @package 
  */

class PwGuestOnline {
	
	/**
	 * ȡһοϢ
	 * 
	 * @param int $ip
	 * @param int $created_time
	 * @return array
	 */
	public function getInfo($ip, $created_time) {
		$ip = (int)$ip;
		$created_time = (int)$created_time;
		if (empty($ip) || empty($created_time)) return false;
		return  $this->_getGuestOnlineDao()->getInfo($ip, $created_time);
	}
	
	/**
	 * ͳο
	 * 
	 * @param int $fid
	 * @param int $tid
	 * @return int
	 */
	public function getOnlineCount($fid = 0, $tid = 0) {
		$fid = (int)$fid;
		$tid = (int)$tid;
		return $this->_getGuestOnlineDao()->getOnlineCount($fid, $tid);
	}
	
	/**
	 * һοϢ
	 * 
	 * @param PwOnlineDm $dm
	 * @return bool
	 */
	public function replaceInfo(PwOnlineDm $dm) {
		$resource = $dm->beforeAdd();
		if ($resource instanceof PwError) return $resource;
		return $this->_getGuestOnlineDao()->replaceInfo($dm->getData());
	}
	
	/**
	 * ɾһοϢ
	 * 
	 * @param int $ip
	 * @param int $createdTime
	 * @return bool
	 */
	public function deleteInfo($ip, $createdTime) {
		$ip = (int)$ip;
		$created_time = (int)$created_time;
		if (empty($ip) || empty($createdTime)) return false;
		return $this->_getGuestOnlineDao()->deleteInfo($ip, $createdTime);
	}
	
	/**
	 * ɾڵοϢ
	 * 
	 * @param int $modifyTime
	 * @return int
	 */
	public function deleteInfoByTime($modifyTime) {
		$modifyTime = (int)$modifyTime;
		if ($modifyTime < 0) return false;
		return $this->_getGuestOnlineDao()->deleteByLastTime($modifyTime);
	}
	
	private function _getGuestOnlineDao() {
		return Wekit::loadDao('online.dao.PwGuestOnlineDao');
	}
}
?>