<?php

 /**
  * û߷
  * 
  * @author $Author: gao.wanggao $ Foxsee@aliyun.com
  * @copyright 2003-2103 phpwind.com
  * @license http://www.phpwind.com
  * @version $Id: PwUserOnline.php 17060 2012-08-31 01:50:31Z gao.wanggao $ 
  * @package 
 */

class PwUserOnline {
	
	/**
	 * жһûǷ
	 * 
	 * @param int $uid
	 * @return bool
	 */
	public function isOnline($uid) {
		$uid = (int)$uid;
		$data = $this->_getUserOnlineDao()->getInfo($uid);
		return  empty($data) ? false : true;
	}
	
	/**
	 * ж϶ûǷ
	 * 
	 * @param array $uids
	 * @return array ûUID
	 */
	public function isOnlines($uids) {
		if (!is_array($uids) || !count($uids)) return array();
		$data = $this->_getUserOnlineDao()->fetchUserOnline($uids);
		return array_keys($data);
	}
	
	/**
	 * ȡһûϢ
	 * 
	 * @param int $uid
	 * @return array
	 */
	public function getInfo($uid) {
		$uid = (int)$uid;
		return $this->_getUserOnlineDao()->getInfo($uid);
	}
	
	/**
	 * ȡûϢ
	 * 
	 * @param array $uids
	 * @return array
	 */
	public function fetchUserOnline($uids) {
		if (!is_array($uids) || !count($uids)) return false;
		return $this->_getUserOnlineDao()->fetchInfo($uids);
	}
	
	/**
	 * ҳȡûID
	 * 
	 * @param int $size
	 * @param int $page
	 * @return array
	 */
	public function getInfoList($fid = 0, $start = 0, $limit = 10) {
		$fid = (int)$fid;
		$limit = (int)$limit;
		$start = (int)$start;
		return $this->_getUserOnlineDao()->getInfoList($fid, $start, $limit);
	}
	
	/**
	 * ͳû
	 * 
	 * @param int $fid
	 * @param int $tid
	 * @return int
	 */
	public function getOnlineCount($fid = 0, $tid = 0) {
		$fid = (int)$fid;
		$tid = (int)$tid;
		return $this->_getUserOnlineDao()->getOnlineCount($fid, $tid);
	}
	
	/**
	 * һϢ
	 * 
	 * @param PwOnlineDm $dm
	 * @return bool
	 */
	public function replaceInfo(PwOnlineDm $dm) {
		$resource = $dm->beforeAdd();
		if ($resource instanceof PwError) return $resource;
		return $this->_getUserOnlineDao()->replaceInfo($dm->getData());
	}
	
	/**
	 * ɾһϢ
	 *
	 * @param int $uid
	 * @return bool
	 */
	public function deleteInfo($uid) {
		$uid = (int)$uid;
		if ($uid < 0) return false;
		return $this->_getUserOnlineDao()->deleteInfo($uid);
	}
	
	/**
	 * ɾϢ
	 * 
	 * @param array $uids
	 * @return int
	 */
	public function deleteInfos($uids) {
		if (!is_array($uids) || !count($uids)) return false;
		return $this->_getUserOnlineDao()->deleteInfos($uids);
	}
	
	/**
	 * ɾڵϢ
	 * 
	 * @param int $modify_time
	 * @return int
	 */
	public function deleteInfoByTime($modify_time) {
		$modify_time = (int)$modify_time;
		if ($modify_time < 0) return false;
		return $this->_getUserOnlineDao()->deleteByLastTime($modify_time);
	}
	
	private function _getUserOnlineDao() {
		return Wekit::loadDao('online.dao.PwUserOnlineDao');
	}
}
?>