<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * ͶƱ¼ӿڷ
 *
 * @author MingXing Sun <mingxing.sun@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwPoll.php 9437 2012-05-07 06:37:33Z hejin $
 * @package poll
 */

class PwPoll {
	
	/**
	 * ȡͶƱ¼
	 * 
	 * @param int $pollid
	 * @return array
	 */
	public function getPoll($pollid) {
		$pollid = (int)$pollid;
		if($pollid < 1) return array();
		return $this->_getPollDao()->getPoll($pollid);
	}
	
	/**
	 * ȡͶƱϢ
	 *
	 * @param array $pollids
	 * @return array
	 */
	public function fetchPoll($pollids){
		if(empty($pollids) || !is_array($pollids)) return array();
		return $this->_getPollDao()->fetchPoll($pollids);
	}
	
	/**
	 * ͶƱб
	 *
	 * @param int $limit
	 * @param int $offset
	 * @param array $orderby
	 */
	public function getPollList($limit, $offset, $orderby = array()) {
		return $this->_getPollDao()->getPollList($limit, $offset, $orderby);
	}
	
	/**
	 * ͳĳʱεͶƱ
	 *
	 * @param int $startTime
	 * @param int $endTime
	 * @return int
	 */
	public function countPollByTime($startTime = 0, $endTime = 0) {
		return $this->_getPollDao()->countPollByTime($startTime, $endTime);
	}
	
	/**
	 * ĳʱεͶƱ
	 * 
	 * @param int $startTime
	 * @param int $endTime
	 * @param int $limit
	 * @param int $offset
	 * @return array
	 */
	public function getPollByTime($startTime, $endTime, $limit, $offset, $orderby = array()) {
		return $this->_getPollDao()->getPollByTime($startTime, $endTime, $limit, $offset, $orderby);
	}
	
	/**
	 *  uid ͳͶƱ
	 * 
	 * @param array $uid
	 * @return int
	 */
	public function countPollByUid($uid){
		$uid = intval($uid);
		if($uid < 1) return 0;
		return $this->_getPollDao()->countPollByUid($uid);
	}
	
	/**
	 * ȡûͶƱб
	 *
	 * @param int $uid
	 * @param int $offset
	 * @param int $limit
	 * @return array
	 */
	public function getPollByUid($uid, $limit, $offset){
		$uid = intval($uid);
		if($uid < 1) return array();
		return $this->_getPollDao()->getPollByUid($uid, $limit, $offset);
	}
	
	/**
	 *  uids ͳͶƱ
	 *
	 * @param array $uids
	 * @return int
	 */
	public function countPollByUids($uids){
		if(empty($uids) || !is_array($uids)) return 0;
		return $this->_getPollDao()->countPollByUids($uids);      
	}
	
	/**
	 * ȡͶƱϢ
	 *
	 * @param array $uids
	 * @param int $offset
	 * @param int $limit
	 * @return array
	 */
	public function fetchPollByUid($uids, $limit, $offset){
		if(empty($uids) || !is_array($uids)) return array();
		return $this->_getPollDao()->fetchPollByUid($uids, $limit, $offset);
	}
	
	/**
	 * ͶƱIDS ͶƱб
	 *
	 * @param int $pollid
	 * @param int $limit
	 * @param int $offset
	 * @return array
	 */
	public function fetchPollByPollid($pollids, $limit, $offset) {
		if(empty($pollids) || !is_array($pollids)) return array();
		return $this->_getPollDao()->fetchPollByPollid($pollids, $limit, $offset);
	}
	
	/**
	 * ͶƱ
	 *
	 * @param PwPollDm $dm
	 * @return int
	 */
	public function addPoll(PwPollDm $dm){
		if (($result = $dm->beforeAdd()) instanceof PwError) return $result;
		return $this->_getPollDao()->addPoll($dm->getData());
	}
	
	/**
	 * ɾͶƱ
	 *
	 * @param int $pollid
	 * @return boolean
	 */
	public function deletePoll($pollid) {
		$pollid = intval($pollid);
		if($pollid < 1) return false;
		return $this->_getPollDao()->deletePoll($pollid);
	}
	
	/**
	 * ͶƱѡ
	 *
	 * @param PwPollDm $dm
	 * @return boolean
	 */
 	public function updatePoll(PwPollDm $dm){
		if (($result = $dm->beforeUpdate()) instanceof PwError) return $result;
		return $this->_getPollDao()->updatePoll($dm->poll_id, $dm->getData());
	}
	
    /**
     * ȡͶƱ DAO
     *
     * @return PwPollDao
     */
	protected function _getPollDao() {
		return Wekit::loadDao('poll.dao.PwPollDao');
	}
}