<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * ͶƱѡDS
 *
 * @author Mingqu Luo<luo.mingqu@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id$
 * @package wind
 */

class PwPollOption {
	
	/**
	 * õѡϢ
	 *
	 * @param int $optionId
	 * @return array
	 */
	public function get($optionid) {
		$optionid = intval($optionid);
		if (1 > $optionid) return array();
		return $this->_getDao()->get($optionid);
	}
	
	/**
	 * öѡϢ
	 *
	 * @param array $optionIds
	 * @return array
	 */
	public function fetch($optionids) {
		if (empty($optionids) && !is_array($optionids)) return array();
		return $this->_getDao()->fetch($optionids);
	}
	
	/**
	 * ͶƱidͶƱѡ
	 *
	 * @param unknown_type $pollid
	 */
	public function getByPollid($pollid) {
		$pollid = intval($pollid);
		if (1 > $pollid) return array();
		return $this->_getDao()->getByPollid($pollid);
	}
	
	/**
	 * ͶƱidsͶƱѡ
	 *
	 * @param unknown_type $pollid
	 */
	public function fetchByPollid($pollids) {
		if (empty($pollids) || !is_array($pollids)) return array();
		return $this->_getDao()->fetchByPollid($pollids);
	}
	
	/**
	 * ͳƸͶƱѡ
	 *
	 * @param int $pollid
	 * @return int
	 */
	public function countByPollid($pollid) {
		$pollid = intval($pollid);
		if (!$pollid) return 0;
		return $this->_getDao()->countByPollid($pollid);
	}
	
	/**
	 * 
	 *
	 * @param PwPollOptionDm $dm
	 */
	public function add(PwPollOptionDm $dm) {
		if (($result = $dm->beforeAdd()) !== true) {
			return $result;
		}
		
		$fieldData = $dm->getData();
		if (!$fieldData) return false;
		
		return $this->_getDao()->add($fieldData);
	}
	
	/**
	 * ɾ
	 *
	 * @param int $optionid
	 * @return bool
	 */
	public function delete($optionid) {
		$optionid = intval($optionid);
		if ($optionid < 1) return false;
		return $this->_getDao()->delete($optionid);
	}
	
	/**
	 * pollidɾ
	 *
	 * @param unknown_type $pollid
	 * @return bool
	 */
	public function deleteByPollid($pollid) {
		$pollid = intval($pollid);
		if ($pollid < 1) return false;
		return $this->_getDao()->deleteByPollid($pollid);
	}
	
	/**
	 * 
	 *
	 * @param PwPollOptionDm $dm
	 */
	public function update(PwPollOptionDm $dm) {
		if (($result = $dm->beforeUpdate()) !== true) {
			return $result;
		}
	
		return $this->_getDao()->update($dm->id, $dm->getData(), $dm->getIncreaseData());
	}
	
	/** 
	 * ɾ
	 *
	 * @param array $optionIds ѡ
	 * @return int
	 */
	public function batchDelete($optionIds) {
		return $this->_getDao()->batchDelete($optionIds);
	}

	/**
	 * 
	 *
	 * @param array $optionids
	 * @param PwPollOptionDm $dm
	 */
	public function batchUpdate($optionids, PwPollOptionDm $dm) {
		if (empty($optionids) || !is_array($optionids)) return false;
		if (($result = $dm->beforeUpdate()) !== true) {
			return $result;
		}
		
		return $this->_getDao()->batchUpdate($optionids, $dm->getData());
	}
		
    /**
     * get PwPollOptionDao
     *
     * @return PwPollOptionDao
     */
	protected function _getDao() {
		return Wekit::loadDao('poll.dao.PwPollOptionDao');
	}
}