<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('SRV:poll.PwPoll');

/**
 * ûͶƱDS
 *
 * @author MingXing Sun <mingxing.sun@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwPollVoter.php 3576 2012-01-12 11:48:47Z mingxing.sun $
 * @package poll
 */

class PwPollVoter {
	
	/**
	 * 
	 *
	 * @param int $userid
	 * @param int $pollid
	 * @param int $optionid
	 * @return int
	 */
	public function add($userid, $pollid, $optionid) {
		$userid = intval($userid);
		$pollid = intval($pollid);
		$optionid = intval($optionid);
		if(!$userid || !$pollid || !$optionid) return false;
		
		$fieldData = array('uid'=> $userid, 'poll_id'=> $pollid, 'option_id'=>$optionid, 'created_time'=> pw::getTime());
		return $this->_getPollVoterDao()->add($fieldData);
	}
	
	/**
	 * ɾ
	 *
	 * @param int $pollid
	 * @return boolean
	 */
	public function deleteByPollid($pollid) {
		$pollid = intval($pollid);
		if($pollid < 1) return false;
		return $this->_getPollVoterDao()->deleteByPollid($pollid);
	}
	
	/**
	 * ͳҲͶƱ
	 *
	 * @param unknown_type $uid
	 */
	public function countByUid($uid) {
		$uid = intval($uid);
		if($uid < 1) return 0;
		return $this->_getPollVoterDao()->countByUid($uid);
	}
	
	/**
	 * ͶƱid,ò
	 *
	 * @param unknown_type $pollid
	 */
	public function getByPollid($pollid) {
		$pollid = intval($pollid);
		if (1 > $pollid) return array();
		return $this->_getPollVoterDao()->getByPollid($pollid);
	}
	
	/**
	 * ȡҲͶƱ
	 *
	 * @param int $uid ûID
	 * @param $limit
	 * @param $offset
	 * @return array
	 */
	public function getPollByUid($uid, $limit, $offset){
		$uid = intval($uid);
		if($uid < 1) return array();
		return $this->_getPollVoterDao()->getPollByUid($uid, $limit, $offset);
	}
	
	/**
	 * ͳƹע˵ͶƱ
	 *
	 * @param array $uids
	 * @return int
	 */
	public function countByUids($uids) {
		if (empty($uids) || !is_array($uids)) return 0;
		return $this->_getPollVoterDao()->countByUids($uids);
	}
	
	/**
	 * ע˵ͶƱ
	 *
	 * @param array $uids
	 * @param int $limit
	 * @param int $offset
	 * @return array
	 */
	public function fetchPollByUid($uids, $limit, $offset) {
		if (empty($uids) || !is_array($uids)) return array();
		return $this->_getPollVoterDao()->fetchPollByUid($uids, $limit, $offset);
	}
	
	/**
	 * ͳĳѡԱ
	 *
	 * @param int $pollid
	 * @param int $optionid
	 * @return int
	 */
	public function countUserByOptionid($optionid) {
		$pollid = intval($pollid);
		if (1 > $optionid) return 0;
		return $this->_getPollVoterDao()->countUserByOptionid($optionid);
	}
	
	/**
	 * ȡĳѡԱ
	 *
	 * @param int $pollid ͶƱID
	 * @param int $optionid ͶƱID
	 * @param int $limit
	 * @param int $offset
	 * @return array
	 */
	public function getUserByOptionid($optionid, $limit = 20, $offset = 0){
		$optionid = intval($optionid);
		if (1 > $optionid) return array();
		return $this->_getPollVoterDao()->getUserByOptionid($optionid, $limit, $offset);
	}
	
	/**
	 * ָͶƱΧڲûͶƱ
	 *
	 * @param unknown_type $pollids
	 */
	public function getPollByUidAndPollid($userid, $pollids) {
		$userid = intval($userid);
		if (!$userid || empty($pollids) || !is_array($pollids)) return array();
		
		$poll = $this->_getPollVoterDao()->getPollByUidAndPollid($userid, $pollids);
		if (!$poll) return array();
			
		$result = array();
		foreach ($poll as $value) {
			$result[] = $value['poll_id'];
		}
		
		return $result;
	}
	
	/**
	 * ûǷͶƱ
	 *
	 * @param int $userid
	 * @param int $pollid
	 * @return bool
	 */
	public function isVoted($userid, $pollid) {
		$userid = intval($userid);
		if (!$userid) return false;
		$pollid = is_array($pollid) ? $pollid : array($pollid);
		$poll = $this->_getPollVoterDao()->getPollByUidAndPollid($userid, $pollid);
		return $poll ? true : false;
	}
	
	/**
	 * ͳĳͶƱ
	 *
	 * @param int $pollid
	 * @return int
	 */
	public function countUser($pollid) {
		$pollid = intval($pollid);
		if (1 > $pollid) return 0;
		return $this->_getPollVoterDao()->countUser($pollid);
	}
	
	/**
	 * ͳĳѡ
	 *
	 * @param int $optionid
	 * @return int
	 */
	public function countByOptionid($optionid) {
		$optionid = intval($optionid);
		if (1 > $optionid) return 0;
		return $this->_getPollVoterDao()->countByOptionid($optionid);
	}

	/**
	 * get PwPollVoterDao
	 *
	 * @return PwPollVoterDao
	 */
	protected function _getPollVoterDao() {
		return Wekit::loadDao('poll.dao.PwPollVoterDao');
	}
}