<?php
defined('WEKIT_VERSION') || exit('Forbidden');


/**
 * ͶƱϵDS
 *
 * @author MingXing Sun <mingxing.sun@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwThreadPoll.php 17614 2012-09-07 03:14:46Z yanchixia $
 * @package poll
 */

class PwThreadPoll {
	
	/**
	 * ͶƱϵ
	 *
	 * @param object $dm
	 * @return int
	 */
 	public function addPoll(PwThreadPollDm $dm) {
		if (($result = $dm->beforeAdd()) instanceof PwError) return $result;
		return $this->_getThreadPollDao()->addPoll($dm->getData());
	}
	
	/**
	 * ͶƱIDɾϵϢ
	 *
	 * @param int $pollid
	 * @return boolean
	 */
	public function deleteByPollid($pollid) {
		$pollid= intval($pollid);
		if($pollid < 1) return false;
		$this->_getThreadPollDao()->deleteByPollid($pollid);
		return true;
	}
	
	/**
	 * ɾͶƱ
	 *
	 * @param int $tid
	 * @return boolean
	 */
	public function deletePoll($tid) {
		$tid= intval($tid);
		if($tid < 1) return false;
		return $this->_getThreadPollDao()->deletePoll($tid);
	}
	
	/**
	 * ɾͶƱ
	 *
	 * @param unknown_type $tids
	 */
	public function batchDeletePoll($tids) {
		if (empty($tids) || !is_array($tids)) return false;
		return $this->_getThreadPollDao()->batchDeletePoll($tids);
	}
	
	/**
	 * tidȡͶƱϵϢ
	 *
	 * @param int $tid
	 * @return array
	 */
	public function getPoll($tid) {
        $tid = intval($tid);
        if($tid < 1) return array();
		return $this->_getThreadPollDao()->getPoll($tid);
	}
	
	/**
	 * tidsȡͶƱϵϢ
	 *
	 * @param int $tids
	 * @return array
	 */
	public function fetchPoll($tids) {
        if (empty($tids) || !is_array($tids)) return array();
		return $this->_getThreadPollDao()->fetchPoll($tids);
	}
	
	/**
	 * pollidȡͶƱϵ
	 *
	 * @param int $pollid ͶƱID
	 * return array
	 */
	public function getPollByPollid($pollid) {
		$pollid = intval($pollid);
		if($pollid < 1) return array();
		return $this->_getThreadPollDao()->getPollByPollid($pollid);
	}
	
	/**
	 * ͨIDȡϵϢ
	 *
	 * @param array $pollids
	 * @return array
	 */
	public function fetchByPollid($pollids) {
		if(empty($pollids) || !is_array($pollids)) return array();
		return $this->_getThreadPollDao()->fetchByPollid($pollids);
	}
	
	/**
	 * get PwThreadPollDao
	 *
	 * @return PwThreadPollDao
	 */
	protected function _getThreadPollDao() {
		return Wekit::loadDao('poll.dao.PwThreadPollDao');
	}
}