<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('LIB:base.PwBaseDm');

/**
 * 
 * ͶƱѡDm
 *
 * @author Mingqu Luo<luo.mingqu@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id$
 * @package wind
 */

class PwPollOptionDm extends PwBaseDm {
	public $id;

	public function __construct($id = 0) {
		$this->id = $id;
	}
	
	/**
	 * ͶƱID
	 *
	 * @param int $pollid
	 * @return PwPollOptionDm
	 */
	public function setPollid($pollid) {
		$this->_data['poll_id'] = intval($pollid);
		return $this;
	}

	/**
	 * ͶƱ
	 *
	 * @param int $votedNum
	 * @return PwPollOptionDm
	 */
	public function addVotedNum($votedNum) {
		$this->_increaseData['voted_num'] = intval($votedNum);
		return $this;
	}

	/**
	 * ͶƱ
	 *
	 * @param int $votedNum
	 * @return PwPollOptionDm
	 */
	public function setVotedNum($votedNum) {
		$this->_data['voted_num'] = intval($votedNum);
		return $this;
	}
	
	/**
	 * ͶƱѡ
	 *
	 * @param string $content
	 * @return PwPollOptionDm
	 */
	public function setContent($content) {
		$this->_data['content'] = trim($content);
		return $this;
	}
	
	/**
	 * ôԴ
	 *
	 * @param string $image
	 * @return PwPollOptionDm
	 */
	public function setImage($image) {
		$this->_data['image'] = $image;
		return $this;
	}
	
	protected function _beforeAdd() {
		return true;
	}

	protected function _beforeUpdate() {
		return true;
	}
}