<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * վ¼
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwReplyRecycle.php 14354 2012-07-19 10:36:06Z jieyin $
 * @package fresh
 */

class PwReplyRecycle {
	
	/**
	 * ȡվ¼
	 *
	 * @param array $pids
	 * @return array
	 */
	public function fetchRecord($pids) {
		if (!$pids || !is_array($pids)) return array();
		return $this->_getDao()->fetchRecord($pids);
	}

	/**
	 * һվ¼()
	 *
	 * @param PwReplyRecycleDm $dm
	 * return bool
	 */
	public function add(PwReplyRecycleDm $dm) {
		if (($result = $dm->beforeAdd()) !== true) {
			return $result;
		}
		return $this->_getDao()->add($dm->getData());
	}
	
	/**
	 * ӻվ¼()
	 *
	 * @param array $dms PwReplyRecycleDmĶ󼯺
	 * @return bool
	 */
	public function batchAdd($dms) {
		if (empty($dms) || !is_array($dms)) return false;
		$data = array();
		foreach ($dms as $key => $dm) {
			if ($dm instanceof PwReplyRecycleDm && $dm->beforeAdd() === true) {
				$data[] = $dm->getData();
			}
		}
		if (!$data) return false;
		return $this->_getDao()->batchAdd($data);
	}
	
	/**
	 * ɾվ¼
	 *
	 * @param array $pids
	 * @return bool
	 */
	public function batchDelete($pids) {
		if (empty($pids)) return false;
		return $this->_getDao()->batchDelete($pids);
	}
	
	/**
	 * ͳƻվ()
	 *
	 * @param object $so
	 * @return int
	 */
	public function countSearchRecord(PwRecycleReplySo $so) {
		return $this->_getDao()->countSearchRecord($so->getData());
	}

	/**
	 * վ
	 *
	 * @param array $param
	 * @return array
	 */
	public function searchRecord(PwRecycleReplySo $so, $limit = 20, $offset = 0) {
		return $this->_getDao()->searchRecord($so->getData(), $so->getOrderby(), $limit, $offset);
	}

	protected function _getDao() {
		return Wekit::loadDao('recycle.dao.PwReplyRecycleDao');
	}
}