<?php

/**
 * ٱDAO
 *
 * @author jinlong.panjl <jinlong.panjl@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id$
 * @package wind
 */
class PwReportDao extends PwBaseDao {
	
	protected $_table = 'report';
	protected $_dataStruct = array('id', 'type', 'type_id', 'content', 'content_url', 'author_userid', 'created_userid', 'created_time', 'reason', 'ifcheck', 'operate_userid', 'operate_time');
	protected $_pk = 'id';
	
	/**
	 * ӵϢ
	 * 
	 * @param array $fields
	 * @return bool 
	 */
	public function add($fields) {
		return $this->_add($fields);
	}
	
	/**
	 * ɾ
	 * 
	 * @param int $id
	 * @return bool 
	 */
	public function delete($id) {
		return $this->_delete($id);
	}
	
	/**
	 * ɾ
	 * 
	 * @param array $ids
	 * @return bool 
	 */
	public function batchDelete($ids) {
		return $this->_batchDelete($ids);
	}
	
	/**
	 * µ
	 * 
	 * @param int $id
	 * @param array $fields
	 * @return bool 
	 */
	public function update($id,$fields) {
		return $this->_update($id, $fields);
	}
	
	/**
	 * 
	 * 
	 * @param array $ids
	 * @param array $fields
	 * @return bool 
	 */
	public function batchUpdate($ids,$fields) {
		return $this->_batchUpdate($ids, $fields);
	}
	
	/**
	 * ȡһ
	 *
	 * @param int $id
	 * @return array
	 */
	public function get($id) {
		return $this->_get($id);
	}
	
	/**
	 * ȡ
	 *
	 * @param array $ids
	 * @return array
	 */
	public function fetch($ids) {
		return $this->_fetch($ids);
	}
	
	/**
	 * ݾٱԴǷͳ
	 *
	 * @param int $type
	 * @param int $ifcheck
	 * @return array
	 */
	public function countByType($ifcheck, $type){
		$where = 'WHERE `ifcheck`=?';
		$parms = array($ifcheck);
		if ($type) {
			$where .= ' AND `type`=?';
			$parms[] = $type;
		}
		$sql = $this->_bindSql('SELECT COUNT(*) FROM %s %s ', $this->getTable(), $where);
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getValue($parms);
	}
	
	/**
	 * ݾٱԴǷȡб
	 *
	 * @param int $type
	 * @param int $ifcheck
	 * @return array
	 */
	public function getListByType($ifcheck, $type, $limit, $start){
		$where = 'WHERE `ifcheck`=?';
		$parms = array($ifcheck);
		if ($type) {
			$where .= ' AND `type`=?';
			$parms[] = $type;
		}
		$sql = $this->_bindSql('SELECT * FROM %s %s ORDER BY `created_time` DESC %s ', $this->getTable(), $where, $this->sqlLimit($limit, $start));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll($parms);
	}
}