<?php
/**
 * the last known user to change this file in the repository  <$LastChangedBy: gao.wanggao $>
 * @author $Author: gao.wanggao $ Foxsee@aliyun.com
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwSpaceBo.php 25545 2013-03-19 05:51:44Z gao.wanggao $ 
 * @package 
 */
 class PwSpaceBo {
 	public $spaceUid = 0;
 	public $visitUid = 0; 		//UID
 	public $spaceUser; 			//ռUser
 	public $space = array(); 	//ռϢ
 	public $tome = 0;			//ռĹϵ
 	
 	const VISITOR = 0; 			//ο
 	const STRANGER = 1;			//İ
 	const MYSELF = 2;			//
 	const ATTENTION = 3;		//˹ע
 	const FOLLOWED = 4;			//ע˵
 	const FRIEND = 5;			//ע

 	
 	
 	public function __construct($spaceUid) {
 		$this->spaceUid = (int)$spaceUid;
 		$this->_getSpaceUser();
 		$this->_getSpace();
	}
	
	/**
	 * ÷û
	 * Enter description here ...
	 * @param unknown_type $visitUid
	 */
	public function setVisitUid($visitUid) {
		$this->visitUid = (int)$visitUid;
	}
	
	/**
	 * ûռĹϵ
	 * Enter description here ...
	 */
	public function setTome($spaceUid, $visitUid) {
		$this->tome = $this->_getTome($spaceUid, $visitUid);
	}
	
 	/**
 	 * жĳkeyʾȨ
 	 * 
 	 * @param string $key 
 	 */
	public function allowView($key = 'space') {
		if ($this->tome == self::MYSELF) return true;
		if (!isset($this->spaceUser['secret'][$key])) {
			//ֻĬϽԼ
			if ($key == 'mobile') {
				$this->spaceUser['secret'][$key] = self::MYSELF;
			} else {
				$this->spaceUser['secret'][$key] = self::VISITOR;
			}
		}
		switch ($this->spaceUser['secret'][$key]) {
			case 0://ȫ
				return true;
			case 1://ѿ
				if ($this->tome == self::MYSELF) return true;
				break;
			case 2://Թע˿
				if ($this->tome == self::ATTENTION)	return true;
				break;
		}
		return false;
	}
	
 	private function _getSpaceUser() {
		$this->spaceUser = Wekit::load('user.PwUser')->getUserByUid($this->spaceUid, PwUser::FETCH_ALL);
		$this->spaceUser['secret'] = unserialize($this->spaceUser['secret']);
		!isset($this->spaceUser['secret']['mobile']) && $this->spaceUser['secret']['mobile'] = self::MYSELF;
	}
	
	private function _getSpace() {
		$this->space =  $this->_getSpaceDs()->getSpace($this->spaceUid);
		empty($this->space['space_name']) && $this->space['space_name'] = $this->spaceUser['username'] . 'ĸ˿ռ';
		empty($this->space['space_privacy']) && $this->space['space_privacy'] = array();
		$this->space['domain'] = $this->_getDomain();

		list($image, $repeat, $fixed, $align) =  unserialize($this->space['back_image']);
		empty($repeat) && $repeat = 'no-repeat';
		empty($fixed) && $fixed = 'scroll';
		empty($align) && $align = 'center';
		$this->space['back_image'] = array($image, $repeat, $fixed, $align);
		$this->space['backbround'] = '';
		if (empty($image)) return;
		$image = Pw::getPath(''). $image;
		$this->space['backbround'] = 'style="';
		$this->space['backbround'] .= 'background-image: url( ' . $image . ');';
		$this->space['backbround'] .= 'background-repeat:' . $repeat . ';' ;
		$this->space['backbround'] .= 'background-attachment:' .$fixed . ';' ;
		$this->space['backbround'] .= 'background-position:top ' . $align . ';';
		$this->space['backbround'] .= '"';
		return;
	}
	
 	private function _getDomain() {
 		if ($this->space['space_domain']) {
 			$root = Wekit::C('domain', 'space.root');
 			if ($root) return 'http://' . $this->space['space_domain'] . '.' . $root;
 		}
 		return WindUrlHelper::createUrl('space/index/run', array('uid' => $this->spaceUid));
 	}
	
	/**
	 * ȡߺͿռĹϵ
	 * 0δ¼,1δע,2,3˹ע, 4,ע˵ 5ע
	 */
 	private function _getTome($spaceUid, $visitUid) {
 		$attention = $followed = false;
 		if ($visitUid == 0) return self::VISITOR;  
 		if ($visitUid == $spaceUid) return self::MYSELF; 
 		if (Wekit::load('attention.PwAttention')->isFollowed($spaceUid, $visitUid)) {
 			$attention = true; //self::ATTENTION; 
 		}
 		if (Wekit::load('attention.PwAttention')->isFollowed($visitUid, $spaceUid)) {
 			$followed = true; //self::FOLLOWED; 
 		}
 		if ($attention && $followed) return self::FRIEND;
 		if ($attention) return self::ATTENTION;
 		if ($followed) return self::FOLLOWED;
 		return self::STRANGER;
 	}
 	
 	private function _getSpaceDs() {
 		return Wekit::load('space.PwSpace');
 	}
 }
?>