<?php

 /**
  * ȡʾ״̬
  *
  * @author jinlong.panjl <jinlong.panjl@aliyun-inc.com>
  * @copyright 2003-2103 phpwind.com
  * @license http://www.phpwind.com
  * @version $Id$
  * @package wind
  */
 class PwPunchService {
	
	/**
	 * ȡҳ״̬
	 * 
	 * @param PwUserBo $user
	 * return array
	 */
	public function getPunch($user = null) {
		!$user && $user = Wekit::getLoginUser();
		$punchData = unserialize($user->info['punch']);
		$havePunch = $this->isPunch($punchData);
		if (!$havePunch) {
			$unPunchDays = $punchData['time'] > 0 ? ceil((Pw::str2time(Pw::time2str(Pw::getTime(),'Y-m-d')) - Pw::str2time(Pw::time2str($punchData['time'],'Y-m-d'))) / 86400) : 1;
			$punchText =  $unPunchDays > 1 ? "{$unPunchDays}δ" : "ÿմ";
			return array(true,$punchText,array());
		}
		$behaviorDays = $this->_getBehavior($punchData['time'],$punchData['days']);
		if($punchData['username'] == $user->username && $havePunch){
			$behaviorDays or $behaviorDays = 1; 
			$punchText = "{$behaviorDays}";
			return array(false,$punchText,array());
		}
		return array(true,'',$punchData);
	}
	
	/**
	 * ȡ˿ռ״̬
	 * 
	 * @param PwUserBo $user
	 * return array
	 */
	public function getSpacePunch(PwSpaceBo $space) {
		switch ($space->tome) {
			case PwSpaceBo::VISITOR:
				return array(false,'',array());
			case PwSpaceBo::STRANGER:
				return array(false,'',array());
			case PwSpaceBo::MYSELF:
				return $this->getPunch();
			case PwSpaceBo::ATTENTION:
				$spaceUser = $space->spaceUser;
				$punchData = unserialize($spaceUser['punch']);	
				$havePunch = $this->isPunch($punchData);
				if (!$havePunch) {
					return array(true,'Ta',array());
				}
				if ($punchData['username'] != $spaceUser['username']) {	
					$data = unserialize($spaceUser['punch']);
					return array(false,'Ta',$data);
				}
				return array(false,'Ta',array());
		}
	}
	
	/**
	 * ǷѾ
	 * 
	 * @param array $punchData
	 * return bool
	 */
	public function isPunch($punchData) {
		$todayStart = Pw::str2time(Pw::time2str(Pw::getTime(),'Y-m-d'));
		$todayEnd = $todayStart + 86400;
		return $punchData['time'] > $todayStart && $punchData['time'] < $todayEnd ? true : false;
	}
	
	/**
	 * ȡ÷ش򿨺ͰѴǷ
	 * 
	 * @param array $punchData
	 * return bool
	 */
	public function getPunchConfig() {
		$config = Wekit::C('site');
		$punchOpen = $config['punch.open'] ? true : false;
		$punchFriendOpen = $config['punch.friend.open'] ? true : false;
		return array($punchOpen,$punchFriendOpen);
	}
	
	/**
	 * ʽʱ
	 * 
	 * @param int $timestamp
	 * return bool
	 */
	public function formatWeekDay($timestamp) {
		$weeksArray = array('','һ','ܶ','','','','');
		$weekDay = Pw::time2str($timestamp, 'w');
		return array(Pw::time2str($timestamp, 'm.d'),$weeksArray[$weekDay]);
	}
 	
 	private function _getBehavior($time,$number) {
 		$time = $time + 86400*2;
 		$time = Pw::str2time(Pw::time2str($time, 'Y-m-d'));
 		
		if($time > 0 && $time < Pw::getTime()) $number = 0;
		return $number;
	}
}
?>