<?php
/**
 * DS
 *
 * @author jinlong.panjl <jinlong.panjl@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id$
 * @package PwTag
 */
class PwTag {
	
	const TYPE_THREAD_TOPIC = 1; //-
	const TYPE_THREAD_REPLY = 2; //-ظ
	const TYPE_WEIBO = 3; //-΢
	
	public $typeMap = array(
		self::TYPE_THREAD_TOPIC => 'threads',
		self::TYPE_THREAD_REPLY => 'posts',
		self::TYPE_WEIBO => 'weibo',
	);
	
	/**
	 * һ
	 *
	 * @param PwTagDao $dm
	 */
	public function addTag(PwTagDm $dm) {
		if (!$dm instanceof PwTagDm) return new PwError('TAG:data_error');
		if (($result = $dm->beforeAdd()) !== true) {
			return $result;
		}
		return $this->_getTagDao()->addTag($dm->getData());
	}
	
	/**
	 * һ
	 *
	 * @param PwTagDao $dm 
	 * return bool
	 */
	public function updateTag(PwTagDm $dm){
		if (!$dm instanceof PwTagDm) return new PwError('TAG:data_error');
		if (($result = $dm->beforeUpdate()) !== true) {
			return $result;
		}
		return $this->_getTagDao()->update($dm->tag_id, $dm->getData(), $dm->getIncreaseData());
	}
	
	/**
	 * »
	 *
	 * @param array $tagDms 
	 * return bool
	 */
	public function batchUpdate($tagDms){
		$data = array();
		foreach ($tagDms as $dm) {
			if (!$dm instanceof PwTagDm) return new PwError('TAG:data_error');
			$tagIds[] = $dm->tag_id;
		}
		return $this->_getTagDao()->batchUpdate($tagIds, $dm->getData(), $dm->getIncreaseData());
	}
	
	/**
	 * ɾ
	 * 
	 * @param array $tagIds
	 */
	public function batchDelete($tagIds){
		if (!is_array($tagIds) || !count($tagIds)) {
			return false;
		}
		return $this->_getTagDao()->batchDelete($tagIds);
	}
	
	/**
	 * Ӹͳ
	 *
	 * @param int $tagId
	 * @param int $updateTime 
	 * return bool
	 */
	public function addTagRecord($tagId,$updateTime){
		$tagId = intval($tagId);
		if ($tagId < 1) {
			return false;
		}
		$data = array(
			'tag_id' => $tagId,
			'update_time' => $updateTime,
		);
		return $this->_getTagRecordDao()->addTagRecord($data);
	}
	
	/**
	 * Ӹͳ
	 *
	 * @param array $fields 
	 * return bool
	 */
	public function batchAddTagRecord($fields){
		if (!is_array($fields) || !$fields) return false;
		$data = array();
		foreach ($fields as $v) {
			$data[] = array(
				'tag_id' => $v['tag_id'],
				'is_reply' => $v['is_reply'],
				'update_time' => $v['update_time'],
			);
		}
		return $this->_getTagRecordDao()->batchAddTagRecord($data);
	}
	
	/**
	 * tag updatetagid
	 *
	 * @param int $fromTagId
	 * @param int $toTagId
	 * @return array 
	 */
	public function updateTagRecordByTagId($fromTagId,$toTagId){
		$fromTagId = intval($fromTagId);
		$toTagId = intval($toTagId);
		if ($fromTagId < 1 || $toTagId < 1) {
			return false;
		}
		return $this->_getTagRecordDao()->updateTagRecordByTagId($fromTagId,$toTagId);
	}
	
	/**
	 * tag relationtagid,content id ϲҵҪ
	 *
	 * @param int $fromTagId
	 * @param int $toTagId
	 * @return array 
	 */
	public function updateTagRelationByTagId($fromTagId,$toTagId){
		$fromTagId = intval($fromTagId);
		$toTagId = intval($toTagId);
		if ($fromTagId < 1 || $toTagId < 1) {
			return false;
		}
		return $this->_getTagRelationDao()->updateTagRelationByTagId($fromTagId,$toTagId);
	}
	
	/**
	 * ݹϵ
	 *
	 * @param PwTagDm
	 * return bool
	 */
	public function addRelation(PwTagDm $dm){
		if (!$dm instanceof PwTagDm) return new PwError('TAG:data_error');
		if ($dm->tag_id < 1) return false;
		$data = $dm->getData();
		if (!$data['param_id']) return false;
		$result = (int)$this->_getTagRelationDao()->addRelation(array_merge(array('tag_id'=>$dm->tag_id),$data));
		$this->_getTagDao()->update($dm->tag_id,'',array('content_count' => $result));
	}
	
	/**
	 * ݹϵ
	 *
	 * @param  array $dms
	 * return bool
	 */
	public function batchAddRelation($dms){
		if (!is_array($dms) || !$dms) return false;
		$data = array();
		foreach ($dms as $dm) {
			if (!$dm instanceof PwTagDm) return new PwError('TAG:data_error');
			$data[] = array_merge(array('tag_id'=>$dm->tag_id),$dm->getData());
		}
		if (!$data) return false;
		return $this->_getTagRelationDao()->batchAddRelation($data);
	}
	
	/**
	 * ݹϵ
	 *
	 * @param PwTagDm
	 * return bool
	 */
	public function updateRelation($typeId,$paramId,$id,$dm){
		if (!$dm instanceof PwTagDm) return new PwError('TAG:data_error');
		if ($id < 1 || $paramId < 1) return false;
		return $this->_getTagRelationDao()->updateRelation($typeId,$paramId,$id,$dm->getData());
	}
	
	/**
	 * ɾݹϵ
	 *
	 * @param int $typeId
	 * @param int $paramId
	 * @param array $tagIds
	 * return bool
	 */
	public function batchDeleteRelationsByType($typeId,$paramId,$tagIds){
		$typeId = intval($typeId);
		$paramId = intval($paramId);
		if ($typeId < 1 || $paramId < 1 || !is_array($tagIds) || !$tagIds) return false;
		$result = $this->_getTagRelationDao()->batchDeleteRelationsByType($typeId,$paramId,$tagIds);
		$this->_getTagDao()->batchUpdate($tagIds,array(),array('content_count' => -1));
		return true;
	}
	
	/**
	 * ɾݹϵ
	 *
	 * @param int $typeId
	 * @param int $paramId
	 * @param int $tagId
	 * return bool
	 */
	public function deleteRelation($typeId,$paramId = null,$tagId){
		$typeId = intval($typeId);
		$paramId = intval($paramId);
		$tagId = intval($tagId);
		if ($typeId < 1 || $tagId < 1) return false;
		$result = $this->_getTagRelationDao()->delete($typeId,$paramId,$tagId);
		$result && $this->_getTagDao()->update($tagId,array(),array('content_count' => -$result));
		return true;
	}
	
	/**
	 * ɾݹϵ
	 *
	 * @param int $typeId
	 * @param array $paramIds
	 * @return bool
	 */
	public function batchDeleteRelation($typeId,$paramIds) {
		$typeId = intval($typeId);
		if ($typeId < 1 || !is_array($paramIds) || !count($paramIds)) {
			return false;
		}
		return $this->_getTagRelationDao()->batchDelete($typeId,$paramIds);
	}
	
	/**
	 * tagIdͳݹϵ
	 *
	 * @param int $tagId
	 * @param int $typeId
	 * @return array 
	 */
	public function countRelationsByTagId($tagId,$typeId,$ifcheck = 1) {
		$tagId = intval($tagId);
		$typeId = intval($typeId);
		$ifcheck = intval($ifcheck);
		if ($tagId < 1 || $typeId < 1) {
			return 0;
		}
		return $this->_getTagRelationDao()->countByTagId($tagId,$typeId,$ifcheck);
	}
	
	/**
	 * 
	 * Żݱ
	 * @param array $tagIds
	 */
	public function deleteTagRecords($tagIds){
		if (!is_array($tagIds) || !$tagIds) {
			return false;
		}
		$this->_getTagRecordDao()->deleteByTagIds($tagIds);
	}
	
	/**
	 * ɾݹϵݱ
	 * 
	 * @param array $tagIds
	 */
	public function deleteRelations($tagIds){
		if (!is_array($tagIds) || !$tagIds) {
			return false;
		}
		$this->_getTagRelationDao()->deleteByTagIds($tagIds);
	}
	
	/**
	 * 
	 * ޸Ļ
	 * @param array $tagIds
	 * @param PwTagDm $dm
	 */
	public function updateTags($tagIds,PwTagDm $dm){
		if (!is_array($tagIds) || !count($tagIds)) return new PwError('TAG:data_error');
		return $this->_getTagDao()->batchUpdate($tagIds,$dm->getData(), $dm->getIncreaseData());
	}
	
	/**
	 * ȡһ
	 *
	 * @param int $tagId
	 * @return array
	 */
	public function getTag($tagId) {
		$tagId = intval($tagId);
		if ($tagId < 1) return false;
		return $this->_getTagDao()->getTag($tagId);
	}
	
	/**
	 * ݹȡ
	 *
	 * @param int $parentTagId
	 * @return array
	 */
	public function getTagByParent($parentTagId) {
		$parentTagId = intval($parentTagId);
		if ($parentTagId < 1) return false;
		return $this->_getTagDao()->getTagByParent($parentTagId);
	}
	
	/**
	 * ݻƻȡһ
	 *
	 * @param string $tagName
	 * @return array
	 */
	public function getTagByName($tagName) {
		return $this->_getTagDao()->getTagByName($tagName);
	}
	
	/**
	 * ݻȡ
	 *
	 * @param array $tagNames
	 * @return array
	 */
	public function getTagsByNames($tagNames) {
		if (!is_array($tagNames) || !count($tagNames)) return array();
		return $this->_getTagDao()->getTagsByNames($tagNames);
	}
	
	/**
	 * count -- ֻ̨ʹ
	 * 
	 * @param string $name
	 * @param int $ifHot
	 * @param int $categoryId
	 * @param int $attentionCountStart
	 * @param int $attentionCountEnd
	 * @param int $contentCountStart
	 * @param int $contentCountEnd
	 * @return int 
	 */
	public function countTagByCondition($name,$ifHot,$categoryId,$attentionCountStart,$attentionCountEnd,$contentCountStart,$contentCountEnd) {
		return $this->_getTagDao()->countTagByCondition($name,$ifHot,$categoryId,$attentionCountStart,$attentionCountEnd,$contentCountStart,$contentCountEnd);
	}
	
	/**
	 * б -- ֻ̨ʹ
	 * 
	 * @param int $start
	 * @param int $limit
	 * @param string $name
	 * @param int $ifHot
	 * @param int $categoryId
	 * @param int $attentionCountStart
	 * @param int $attentionCountEnd
	 * @param int $contentCountStart
	 * @param int $contentCountEnd
	 * @return array 
	 */
	public function getTagByCondition($start,$limit,$name,$ifHot,$categoryId,$attentionCountStart,$attentionCountEnd,$contentCountStart,$contentCountEnd) {
		return $this->_getTagDao()->getTagByCondition($start,$limit,$name,$ifHot,$categoryId,$attentionCountStart,$attentionCountEnd,$contentCountStart,$contentCountEnd);
	}
	
	/**
	 * 
	 * ݲȡػ
	 */
	public function getTagsByParamIds($typeId,$paramIds){
		$typeId = intval($typeId);
		if ($typeId < 1 || !is_array($paramIds) || !count($paramIds)) return array();
		return $this->_getTagDao()->getTagsByParamIds($typeId,$paramIds);
	}
	
	/**
	 * ɾ
	 *
	 * @param int $updateTime
	 * @return bool
	 */
	public function deleteExpireHotTag($updateTime) {
		$updateTime = intval($updateTime);
		if ($updateTime < 1) return false;
		return $this->_getTagRecordDao()->deleteByTime($updateTime);
	}
	
	/**
	 * ͳŻ
	 *
	 * @param int $num
	 * @return array
	 */
	public function getCountHotTag($categoryId = 0,$num) {
		$categoryId = intval($categoryId);
		$num = intval($num);
		if ($num < 1) return array();
		if (!$categoryId) {
			return $this->_getTagRecordDao()->getHotTags($num);
		} else {
			return $this->_getTagRecordDao()->getHotTagsByCategory($categoryId,$num);
		}
	}
	
	/**
	 * tagIdȡݹϵ
	 *
	 * @param int $tagId
	 * @param int $typeId
	 * @return array
	 */
	public function getTagRelation($tagId,$typeId,$ifcheck = 1,$offset,$num=4) {
		$tagId = intval($tagId);
		$typeId = intval($typeId);
		$ifcheck = intval($ifcheck);
		if ($tagId < 1 || $typeId < 1) {
			return array();
		}
		return $this->_getTagRelationDao()->getByTagId($tagId,$typeId,$ifcheck,$offset,$num);
	}
	
	/**
	 * ȡҹעĻ
	 *
	 * @param int $uid
	 * @param int $start
	 * @param int $limit
	 * @return array 
	 */
	public function getAttentionByUid($uid,$start,$limit) {
		$uid = intval($uid);
		if ($uid < 1) return array();
		return $this->_getTagDao()->getAttentionTag($uid,$start,$limit);
	}
	
	/**
	 * ȡ
	 *
	 * @param array $tagIds
	 * @return array 
	 */
	public function fetchTag($tagIds) {
		if (!is_array($tagIds) || !count($tagIds)) return array();
		return $this->_getTagDao()->fetchTag($tagIds);
	}
	
	/**
	 * Ӧͺidȡϵ
	 *
	 * @param int $typeId
	 * @param int $paramId
	 * @return array 
	 */
	public function getTagRelationByType($typeId,$paramId) {
		$typeId = intval($typeId);
		$paramId = intval($paramId);
		if ($typeId < 1 || $paramId < 1) {
			return array();
		}
		return $this->_getTagRelationDao()->getByTypeId($typeId,$paramId);
	}	
	
	/**
	 * Ӧͺidȡ
	 *
	 * @param int $typeId
	 * @param int $paramId
	 * @return array 
	 */
	public function getTagByType($typeId,$paramId) {
		$tagRelations = $this->getTagRelationByType($typeId,$paramId);
		return $this->fetchTag(array_keys($tagRelations));
	}	
	
	/**
	 * ͺIDsȡ
	 *
	 * @param int $typeId
	 * @param array $paramIds
	 * @return array
	 */
	public function fetchByTypeIdAndParamIds($typeId,$paramIds) {
		if ($typeId < 1 || !is_array($paramIds) || !$paramIds) {
			return array();
		}
		return $this->_getTagRelationDao()->fetchByTypeIdAndParamIds($typeId,$paramIds);
	}	
	
	/**
	 * @return PwTagDao
	 */
	protected function _getTagDao() {
		return Wekit::loadDao('tag.dao.PwTagDao');
	}
	
	/**
	 * @return PwTagRecordDao
	 */
	protected function _getTagRecordDao() {
		return Wekit::loadDao('tag.dao.PwTagRecordDao');
	}
	
	/**
	 * @return PwTagRelationDao
	 */
	protected function _getTagRelationDao() {
		return Wekit::loadDao('tag.dao.PwTagRelationDao');
	}
}