<?php
Wind::import('SRV:tag.dm.PwTagDm');
/**
 * ҵ
 *
 * @author peihong <peihong.zhangph@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwTagService.php 3833 2012-02-16 03:32:27Z peihong.zhangph $
 * @package src.service.tag.srv
 */
class PwTagService {

	private $expireDay = 7;
	
	/**
	 * ӻ
	 *
	 * @param array $dmArray
	 */
	public function addTags($dmArray) {
		if(!is_array($dmArray) || !$dmArray) return false;
		$_tagsInfo = $this->_getTagDs()->getTagsByNames(array_keys($dmArray));
		$tagsKeys = $tagsInfo = array();
		foreach ($_tagsInfo as $k => $tag){
		    $tagsKeys[] = strtolower($k);
		    $k = strtolower($k);
		    $tagsInfo[$k] = $tag;
		}
		$dmArrays = array();
		foreach ($dmArray as $k => $dm){
			$k = strtolower($k);
		    $dmArrays[$k] = $dm;
		}
		$tagRecords = $updateTagDms = $relationDms = $attentionTags = array();
		foreach ($dmArrays as $k => $dm) {
			$k = strtolower(trim($k));
			if (!$k || !$dm instanceof PwTagDm) continue;
			$time = Pw::getTime();
			$dm->setCreatedTime($time);
			$dm->setName($k);
			if (in_array($k, $tagsKeys)) {
				$dm->tag_id = $tagsInfo[$k]['parent_tag_id'] ? $tagsInfo[$k]['parent_tag_id'] : $tagsInfo[$k]['tag_id'];
				$dm->setContentTagId($tagsInfo[$k]['tag_id']);
				$dm->setIfhot($tagsInfo[$k]['ifhot']);
				$updateTagDm = new PwTagDm($dm->tag_id);
				$updateTagDm->addContentCount(1);
				$updateTagDms[] = $updateTagDm;
			} else {
				$dm->setContentCount(1);
				$result = $this->_getTagDs()->addTag($dm);
				if ($result instanceof PwError) {
					return $result;
				}
				$dm->tag_id = $result;
				$dm->setContentTagId($dm->tag_id);
			}
			if ($dm->getIfhot()) {
				$tagRecords[] = array('tag_id' => $dm->tag_id, 'update_time' => $time);
			}
			$relationDms[] = $dm;
		//	$this->addAttention($dm->getCreateUid(),$dm->tag_id);
		}
		
		$this->_getTagDs()->batchAddRelation($relationDms);
		$this->_getTagDs()->batchAddTagRecord($tagRecords);
		$updateTagDms && $this->_getTagDs()->batchUpdate($updateTagDms);
		return $dm->tag_id;
	}
	
	/**
	 * ӻ
	 *
	 * @param int $typeId
	 * @param int $paramId
	 * @param array $dmArray
	 */
	public function updateTags($typeId,$paramId,$dmArray) {
		if (!$typeId || !$paramId) {
			return new PwError('data.error');
		}
		$tagsInfo = $this->_getTagDs()->getTagRelationByType($typeId,$paramId);
		$this->_getTagDs()->batchDeleteRelationsByType($typeId,$paramId,array_keys($tagsInfo));
		$dmArray && $this->addTags($dmArray);
		$types = $this->_getTypeMap();
		$tags = $this->getTagByType($types[$typeId],$paramId);
		Wind::import('SRV:forum.dm.PwTopicDm');
		$dm = new PwTopicDm($paramId);
		$dm->setTags($this->_formatTags($tags));
		Wekit::load('forum.PwThread')->updateThread($dm,PwThread::FETCH_CONTENT);
		return true;
	}
	
	/**
	 * parent_id0
	 *
	 * @param array $tagIds
	 * @return bool
	 */
	public function clearTagsByParentIds($tagIds){
		if (!is_array($tagIds) || !count($tagIds)) return false;
		Wind::import('SRV:tag.dm.PwTagDm');
		$dm = new PwTagDm();
		$dm->setParent(0);
		return $this->_getTagDs()->updateTags($tagIds,$dm);
	}
	
	/**
	 * 
	 * ȡ
	 * @param int $tagId
	 * @param string $typeName
	 * @param int $num
	 */
	public function getContentsByTypeName($tagId,$typeName,$ifcheck,$offset=0,$num = 4){
		$tagId = intval($tagId);
		$num = intval($num);
		$typeId = $this->getTypeIdByTypeName($typeName);
		$relations = $this->_getTagDs()->getTagRelation($tagId,$typeId,$ifcheck,$offset,$num);
		$ids = $array = $return = array();
		foreach ($relations as $v) {
			$array[$v['param_id']] = $v;
			$ids[] = $v['param_id'];
		}
		if (!$ids) return array();
		$action = $this->_getTagAction($typeName);
		if (!$action) return new PwError('undefined content type');
		$result = $action->getContents($ids);
		foreach ($ids as $id) {
			$result[$id] && $result[$id]['tagifcheck'] = $array[$id]['ifcheck'];
			$return[$id] = $result[$id];
		}
		usort($return, array($this, 'cmp'));
		return $return;
	}
	
	private static function cmp($a, $b) {
		    return strcmp($b["created_time"], $a["created_time"]);
	}
	
	public function getHotTags($categoryId = 0,$num = 100) {
		return Wekit::cache()->get('hot_tags', array($categoryId, $num));
	}
	
	/**
	 * 
	 * ȡŻ
	 * @param ing $categoryId
	 * @param ing $num
	 */
	public function getHotTagsNoCache($categoryId = 0,$num = 100){
		// ɾ
		$updateTime = pw::getTime() - 86400 * $this->expireDay;
		$this->_getTagDs()->deleteExpireHotTag($updateTime);
		$tags = $this->_getTagDs()->getCountHotTag($categoryId,$num);
		$tagIds = array_keys($tags);
		if (!$tagIds) return array();
		return $this->_getTagDs()->fetchTag($tagIds);
	}
	
	/**
	 * 
	 * ȡݵ
	 * @param string $typeName
	 * @param array $params ݲID
	 * @param array $excludeTagIds ųĵǰб format: array(tag_id_param_id,..);
	 */
	public function getRelatedTags($typeName,$params,$excludeTagIds = array()){
		$relatedTags = array();
		$params = array_unique($params);
		$typeId = $this->getTypeIdByTypeName($typeName);
		$params and $tmpRelatedTags = $this->_getTagDs()->getTagsByParamIds($typeId,$params);
		foreach ($tmpRelatedTags as $v) {
			$tmpTagId = $v['tag_id'];
			$tmpParamId = $v['param_id'];
			//if (in_array("{$tmpTagId}_$tmpParamId", $excludeTagIds)) continue;
			$relatedTags[$tmpParamId][$tmpTagId] = $v;
		}
		return $relatedTags;
	}
	
	/**
	 * 
	 * ȡעԱ
	 * @param unknown_type $tagId
	 */
	public function getTagMembers($tagId,$offset,$num = 20){
		$count = $this->_getTagAttentionDs()->countAttentionByTagId($tagId);
		if ($count < 1) {
			return array(0,array());
		}
		$attentions = $this->_getTagAttentionDs()->getAttentionUids($tagId,$offset,$num);
		$users = $this->_getUserDs()->fetchUserByUid(array_keys($attentions));
		return array($count,$users);
	}
	
	/**
	 * ȡҹעĻ
	 *
	 * @param int $uid
	 * @param int $start
	 * @param int $limit
	 * @return array 
	 */
	public function getAttentionTags($uid,$start,$limit) {
		$uid = intval($uid);
		$count = $this->_getTagAttentionDs()->countAttentionByUid($uid);
		if ($count < 1) {
			return array(0,array());
		}
		$relations = $this->_getTagDs()->getAttentionByUid($uid,$start,$limit);
		$tags = $this->_getTagDs()->fetchTag(array_keys($relations));
		return array($count,$tags);
	}
	
	/**
	 * Ӧͺidȡ
	 *
	 * @param string $type
	 * @param int $paramId
	 * @param int $uid ע
	 * @return array 
	 */
	public function getTagByType($type,$paramId) {
		$paramId = intval($paramId);
		if (!$type || $paramId < 1) {
			return array();
		}
		$typeId = $this->getTypeIdByTypeName($type);
		if (!$typeId) return array();
		$tagRelations = $this->_getTagDs()->getTagRelationByType($typeId,$paramId);
		if (!count($tagRelations)) return array();
		$tagIds = array_keys($tagRelations);
		return $this->_getTagDs()->fetchTag($tagIds);
	}
	
	/**
	 * СƬ
	 *
	 * @param string $name
	 * @param int $uid ע
	 * @return array 
	 */
	public function getTagCard($name,$uid = null) {
		$tag = $this->_getTagDs()->getTagByName($name);
		if (!$tag) return array();
		if ($uid) {
			$attention = $this->_getTagAttentionDs()->isAttentioned($uid,$tag['tag_id']);
		}
		$attention && $tag['isAttention'] = $attention ? true : false;
		return $tag;
	}
	
	/**
	 * 
	 * ȡID
	 * @param string $typeName
	 */
	public function getTypeIdByTypeName($typeName){
		$types = array_flip($this->_getTypeMap());
		return $types[$typeName];
	}
	
	/**
	 * ע
	 *
	 * @param int $uid
	 * @param int $tagId
	 * @return array 
	 */
	public function addAttention($uid,$tagId) {
		// Ƿע
		if ($this->_getTagAttentionDs()->isAttentioned($uid,$tagId)) return new PwError('Tag:have.attentioned');
		if (($count = $this->_getTagAttentionDs()->countAttentionByUid($uid)) > 49) {
			return new PwError('Tag:attentioned.count.error');
		}
		$result = (int)$this->_getTagAttentionDs()->addAttention($uid,$tagId);
		// »
		Wind::import('SRV:tag.dm.PwTagDm');
		$dm = new PwTagDm($tagId);
		$dm->addAttentionCount($result);
		return $this->_getTagDs()->updateTag($dm);
	}
	
	/**
	 * ȡעĻ
	 *
	 * @param int $uid
	 * @param int $tagId
	 * @return array 
	 */
	public function deleteAttention($uid,$tagId) {
		$result = (int)$this->_getTagAttentionDs()->deleteAttention($uid,$tagId);
		// »
		Wind::import('SRV:tag.dm.PwTagDm');
		$dm = new PwTagDm($tagId);
		$dm->addAttentionCount(-$result);
		return $this->_getTagDs()->updateTag($dm);
	}
	
	/**
	 * ɾ -- ֻɾӿ
	 *
	 * @param array $tagIds
	 * @return bool
	 */
	public function deleteByTagIds($tagIds) {
		$result = $this->_getTagDs()->fetchTag($tagIds);
		if (!$result) return false;
		foreach ($result as $tag) {
			$tag['tag_logo'] && Pw::deleteAttach($tag['tag_logo']);
		}
		$tagIds = array_keys($result);
		// ɾŻ
		$this->_getTagDs()->deleteTagRecords($tagIds);
		// ɾϵ
		$this->_getTagCateGoryDs()->deleteCateGoryRelations($tagIds);
		// ɾע
		$this->_getTagAttentionDs()->deleteAttentions($tagIds);
		// ɾݹϵ
		$this->_getTagDs()->deleteRelations($tagIds);
		$this->clearTagsByParentIds($tagIds);//TODO
		// ɾ
		$this->_getTagDs()->batchDelete($tagIds);
		return true;
	}

	/**
	 * 
	 * ȡĳĹ
	 * @param int $tagId
	 */
	public function removeRelatedTopic($tagId){
		$tagId = intval($tagId);
		$childTags = $this->_getTagDs()->getTagByParent($tagId);
		if (!$childTags) return true;
		$childTagIds = array();
		foreach ($childTags as $tag){
			$childTagIds[] = $tag['tag_id'];
			$this->_getTagDs()->updateTagRelationByTagId($tagId,$tag['tag_id']);
		}
		
		Wind::import('SRV:tag.dm.PwTagDm');
		$dm = new PwTagDm();
		$dm->setParent(0);
		$this->_getTagDs()->updateTags($childTagIds,$dm);
	}
	
	/**
	 * б
	 * 
	 * @param int $start
	 * @param int $limit
	 * @param string $name
	 * @param int $ifHot
	 * @param int $categoryId
	 * @param int $attentionCountStart
	 * @param int $attentionCountEnd
	 * @param int $contentCountStart
	 * @param int $contentCountEnd
	 * @return array 
	 */
	public function getTagByCondition($start,$limit,$name,$ifHot,$categoryId,$attentionCountStart,$attentionCountEnd,$contentCountStart,$contentCountEnd) {
		$count = $this->_getTagDs()->countTagByCondition($name,$ifHot,$categoryId,$attentionCountStart,$attentionCountEnd,$contentCountStart,$contentCountEnd);
		if ($count < 1) return array(0,array());
		$tags = $this->_getTagDs()->getTagByCondition($start,$limit,$name,$ifHot,$categoryId,$attentionCountStart,$attentionCountEnd,$contentCountStart,$contentCountEnd);
		//ȡϵ
		$categoryRelations = $this->_getTagCateGoryDs()->getRelationsByTagIds(array_keys($tags));
		$tmpCategories = array();
		foreach ($categoryRelations as $l) {
			$tmpCategories[$l['tag_id']][] = $l['category_id'];
		}
		foreach ($tags as $k => $v) {
			$v['parent_tag_id'] or $v['joinTag'] = $this->_getTagDs()->getTagByParent($k);
			$v['categories'] = $tmpCategories[$k];
			$tags[$k] = $v;
		}
		return array($count,$tags);
	}
	
	/**
	 * ɾݹϵ
	 *
	 * @param string $type
	 * @param array $paramIds
	 * @return bool
	 */
	public function batchDeleteRelation($typeId,$paramIds) {
		return $this->_getTagDs()->batchDeleteRelation($typeId,$paramIds);
	}
	
	/**
	 *  ##
	 * 
	 * @param string $content
	 * @return string
	 */
	public function parserTags($content) {
		if (!$content) return array();
		preg_match_all('/\#(.*)\#/iUs', $content, $matches);
		if (!$matches[1]) return array();
		$tags = array();
		foreach ($matches[1] as $v) {
			$v = trim($v);
			if (!$v) continue;
			$tags[] = $v;
		}
		return $tags;
	}
	
	/**
	 * 
	 * ȡIDĶӦϵ
	 * @return array
	 */
	private function _getTypeMap(){
		return $this->_getTagDs()->typeMap;
	}
	
	/**
	 * 
	 * ȡTagʵַ
	 * @param string $typeName
	 */
	private function _getTagAction($typeName){
		$typeName = strtolower($typeName);
		if (!$this->getTypeIdByTypeName($typeName)) return null;
		$className = 'PwTag' . ucfirst($typeName);
		Wind::import('SRV:tag.srv.action.' . $className);
		return new $className;
	}
	
	protected function _formatTags($tags) {
		if (!$tags) return false;
		$tagname = array();
		foreach ($tags as $v) {
			$tagname[] = $v['tag_name'];
		}
		return implode(',',$tagname);
	}
	
	private function _getCacheService(){
		Wind::import("Lib:utility.PwCacheService");
		return new PwCacheService();
	}
	
	/**
	 * DS
	 * 
	 * @return PwTag
	 */
	private function _getTagDs(){
		return Wekit::load('tag.PwTag');
	}
	
	/**
	 * DS
	 * 
	 * @return PwTagCateGory
	 */
	private function _getTagCateGoryDs(){
		return Wekit::load('tag.PwTagCateGory');
	}
	
	/**
	 * עDS
	 * 
	 * @return PwTagAttention
	 */
	private function _getTagAttentionDs(){
		return Wekit::load('tag.PwTagAttention');
	}
	
	/**
	 * 
	 * Enter description here ...
	 * @return PwUser
	 */
	private function _getUserDs(){
		return Wekit::load('user.PwUser');
	}
}