<?php
Wind::import('SRV:task.dm.PwTaskDm');
/**
 * ϵdata service
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwTask.php 18748 2012-09-27 03:45:32Z xiaoxia.xuxx $
 * @package service.task
 */
class PwTask {

	/**
	 * pw_task¼
	 *
	 * @param PwTaskDm $dm
	 * @return PwError|int
	 */
	public function addTask($dm) {
		if (!$dm instanceof PwTaskDm) return new PwError('TASK:datamodel.illegal');
		if (($r = $dm->beforeAdd()) instanceof PwError) return $r;
		//pw_task¼
		$id = $this->_taskDao()->add($dm->getData());
		if (!$id) return new PwError('TASK:addtask.fail');
		/*״̬򽫸ӵgroup*/
		if (1 == $dm->getField('is_open')) {
			$dm->setTaskId($id);
			$result = $this->_taskGroupDao()->batchReplaceTaskGroups($dm->getTaskGroupData());
			if ($result instanceof PwError) return $result;
		}
		return $id;
	}

	/**
	 * һϢfor pw_task
	 *
	 * @param int $id
	 * @param PwTaskDm $dm
	 * @return PwError|boolean
	 */
	public function updateTask($dm) {
		if (!$dm instanceof PwTaskDm) return new PwError('TASK:datamodel.illegal');
		if (($r = $dm->beforeUpdate()) instanceof PwError) return $r;
		//pw_task¼
		$this->_taskDao()->update($dm->getTaskId(), $dm->getData());
		$this->_taskGroupDao()->deleteByTaskId($dm->getTaskId());
		if (1 == $dm->getField('is_open')) return $this->_taskGroupDao()->batchReplaceTaskGroups(
			$dm->getTaskGroupData());
		return true;
	}

	/**
	 * û
	 *
	 * @param int $uid
	 * @param array $cache array($last_id, array($id1, $id2,..))
	 * @return PwError|boolean
	 */
	public function updateUserTaskCache($uid, $cache = array(0, array())) {
		if (0 >= ($uid = intval($uid))) return new PwError('TASK:param.illegal');
		return $this->_taskCacheDao()->update(
			array('uid' => $uid, 'task_ids' => serialize($cache)));
	}

	/**
	 * ɾһ
	 *
	 * @param int $id
	 * @return PwError|boolean
	 */
	public function deleteTask($id) {
		if (0 >= ($id = intval($id))) return new PwError('TASK:id.illegal');
		//ɾpw_task¼
		$this->_taskDao()->delete($id);
		return $this->_taskGroupDao()->deleteByTaskId($id);
	}

	/**
	 * ȡб
	 *
	 * @param int $num
	 * @param int $start
	 * @return array
	 */
	public function getTaskList($num = 10, $start = 0) {
		return $this->_taskDao()->getTaskList((int) $num, (int) $start);
	}
	
	/**
	 * IDбȡ¼
	 *
	 * @param array $taskIds
	 * @return array
	 */
	public function fetchNextTaskList($taskIds) {
		if (!$taskIds) return array();
		return $this->_taskDao()->fetchNextTaskList($taskIds);
	}

	/**
	 * ȡһ¼
	 *
	 * @param int $id
	 * @return array
	 */
	public function get($id) {
		return $this->_taskDao()->get((int) $id);
	}

	/**
	 * ȡһϢ
	 *
	 * @param array $ids
	 * @return array
	 */
	public function gets($ids) {
		if (empty($ids)) return array();
		return $this->_taskDao()->fetch((array) $ids);
	}

	/**
	 * ȡidڴ˷ΧڵĿб
	 *
	 * @param array $no_periods ûѽлɵķid
	 * @param array $gids
	 * @param int $start
	 * @param int $num
	 * @param int $endTime 
	 * @return array
	 */
	public function getApplicableTasks($no_periods, $gids, $num = 10, $start = 0, $endTime) {
		//ѯpw_task_groupвЩidеļ¼
		return $this->_taskGroupDao()->getApplicableTasks($no_periods, $gids, (int)$num, (int)$start, (int)$endTime);
	}

	/**
	 * ûidѯûĻ
	 *
	 * @param int $uid
	 * @return array
	 */
	public function getTaskCacheByUid($uid) {
		if (0 >= ($uid = intval($uid))) return array();
		$result = $this->_taskCacheDao()->get($uid);
		return unserialize($result);
	}

	/**
	 * ȡͨͨԶ˵id
	 *
	 * @param int $last_id ϴԶid
	 * @param array $gids
	 * @param int $limit 
	 * @param int $endTime
	 * @return array
	 */
	public function getAutoApplicableTask($last_id, $gids, $limit = 1, $endTime = 0) {
		$last_id = intval($last_id);
		if (!is_array($gids)) return array();
		return $this->_taskGroupDao()->getAutoApplicableTask($last_id, $gids, (int) $limit, 
			(int) $endTime);
	}

	/**
	 * ȡidڴ˷ΧڵĿб
	 *
	 * @param int $pre_id
	 * @param int $startTime
	 * @param int $endTime
	 * @return array
	 */
	public function getNextAutoTasks($pre_id, $startTime, $endTime) {
		if (0 >= ($pre_id = intval($pre_id))) return array();
		return $this->_taskDao()->getNextAutoTasks($pre_id, (int) $startTime, (int) $endTime);
	}

	/**
	 * ȡ
	 *
	 * @return array
	 */
	public function getAll() {
		return $this->_taskDao()->getAll();
	}

	/**
	 * ͳ
	 *
	 * @return int
	 */
	public function countAll() {
		return $this->_taskDao()->count();
	}

	/**
	 * ȡidڴ˷ΧڵĿ
	 *
	 * @param array $noIds
	 * @param array $gids
	 * @param int $endTime
	 */
	public function countApplicableTasks($noIds = array(), $gids, $endTime) {
		return $this->_taskGroupDao()->countApplicableTasks($noIds, $gids, (int) $endTime);
	}

	/**
	 * @return PwTaskCacheDao
	 */
	private function _taskCacheDao() {
		return Wekit::loadDao('task.dao.PwTaskCacheDao');
	}

	/**
	 * @return PwTaskGroupDao
	 */
	private function _taskGroupDao() {
		return Wekit::loadDao('task.dao.PwTaskGroupDao');
	}

	/**
	 * @return PwTaskDao
	 */
	private function _taskDao() {
		return Wekit::loadDao('task.dao.PwTaskDao');
	}
}

?>