<?php
/**
 * ûݷ
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwTaskUser.php 16415 2012-08-23 07:53:40Z xiaoxia.xuxx $
 * @package service.task
 */
class PwTaskUser {
	
	/*û״ֵ̬1:ڽе*/
	const DOING = 1;
	/*û״ֵ̬2Ѿɵȴȡ*/
	const UNREWARD = 2;
	/*û״ֵ̬4Ѿɵ*/
	const COMPLETE = 4;

	/**
	 * ӻ޸һû
	 *
	 * @param PwTaskUserDm $data
	 * @return boolean
	 */
	public function replaceUserTask(PwTaskUserDm $dm) {
		if (($r = $dm->beforeUpdate()) instanceof PwError) return $r;
		return $this->_taskUserDao()->replaceUserTask($dm->getData());
	}

	/**
	 * һû
	 *
	 * @param int $taskid
	 * @param int $uid
	 * @param PwTaskUserDm $dm
	 * @return PwError|boolean
	 */
	public function update($taskid, $uid, PwTaskUserDm $dm) {
		if (0 >= ($taskid = intval($taskid)) || 0 >= ($uid = intval($uid))) return new PwError(
			'TASK:id.illegal');
		return $this->_taskUserDao()->updateByTaskIdAndUid($taskid, $uid, $dm->getData());
	}

	/**
	 * idɾpw_task_user¼
	 *
	 * @param int $id
	 * @return boolean
	 */
	public function delete($taskid) {
		if (0 >= ($taskid = intval($taskid))) return new PwError('TASK:id.illegal');
		return $this->_taskUserDao()->deleteByTaskid($taskid);
	}

	/**
	 * ûidɾpw_task_user¼
	 *
	 * @param int $uid
	 * @return boolean
	 */
	public function deleteByUid($uid) {
		if (($uid = intval($uid)) < 1) return false;
		return $this->_taskUserDao()->deleteByUid($uid);
	}

	/**
	 * ûidɾpw_task_user¼
	 *
	 * @param int $uid
	 * @return boolean
	 */
	public function batchDeleteByUid($uids) {
		if (empty($uids)) return false;
		return $this->_taskUserDao()->batchDeleteByUid($uids);
	}
	
	/**
	 * ǷԲѯû
	 *
	 * @param int $uid
	 * @param int $isPeriod 10
	 * @return array
	 */
	public function getByIsPeriod($uid, $isPeriod) {
		if (0 >= ($uid = intval($uid)) || !in_array((int) $isPeriod, array(0, 1))) return array();
		return $this->_taskUserDao()->getTasksByIsPeriod($uid, $isPeriod);
	}

	/**
	 * ȡһ¼
	 *
	 * @param int $uid
	 * @param int $taskid
	 * @return array
	 */
	public function get($uid, $taskid) {
		if (0 >= ($uid = intval($uid)) || 0 >= ($taskid = intval($taskid))) return array();
		return $this->_taskUserDao()->get($taskid, $uid);
	}

	/**
	 * ȡû
	 *
	 * @param int $uid
	 * @param array $taskids
	 * @return array
	 */
	public function gets($uid, $taskids) {
		if (empty($taskids)) return array();
		return $this->_taskUserDao()->gets((array) $taskids, $uid);
	}

	/**
	 * ״̬ȡҵб
	 *
	 * @param int $uid
	 * @param status û״̬ ʹλ㣬3ʾ+δ콱
	 * 1 ʾ룬
	 * 2 ʾδ콱
	 * 4 ʾ콱
	 * @param int $num
	 * @param int $start
	 * @return array
	 */
	public function getMyTaskByStatus($uid, $status, $num = 10, $start = 0) {
		return $this->_taskUserDao()->getMyTasksByStatus($uid, $status, (int)$num, (int)$start);
	}

	/**
	 * ״̬ѯҵ
	 *
	 * @param int $uid
	 * @param int $status ͬ@method getMyTaskByStatus
	 * 1 ʾ룬
	 * 2 ʾδ콱
	 * 4 ʾ콱
	 * @return int
	 */
	public function countMyTasksByStatus($uid, $status) {
		if (0 > ($status = intval($status)) || 0 >= ($uid = intval($uid))) return 0;
		return $this->_taskUserDao()->countMyTasksByStatus($uid, $status);
	}

	/**
	 * @return PwTaskUserDao
	 */
	private function _taskUserDao() {
		return Wekit::loadDao('task.dao.PwTaskUserDao');
	}
}

?>