<?php
Wind::import('LIB:base.PwBaseDm');
/**
 * ϵģ
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwTaskDm.php 20911 2012-11-19 06:56:00Z xiaoxia.xuxx $
 * @package service.task.dm
 */
class PwTaskDm extends PwBaseDm {
	
	const MAXENDTIME = 4197024000;
	/**
	 * @var PwTaskRewardDoBase 
	 */
	protected $decoration = null;
	
	/**
	 * id
	 *
	 * @var int
	 */
	protected $id;
	
	protected $groups = array();

	/**
	 * װû
	 *
	 * @return array 
	 */
	public function getTaskGroupData() {
		if ($this->id <= 0) return array();
		$tmp = array();
		$endTime = isset($this->_data['end_time']) ? $this->_data['end_time'] : 0;
		$endTime = $endTime ? $endTime : self::MAXENDTIME;
		$groups = $this->_data['is_display_all'] ? array(-1) : $this->groups;
		foreach ($groups as $v) {
			$data = array();
			$data['taskid'] = $this->id;
			$data['gid'] = $v;
			$data['is_auto'] = isset($this->_data['is_auto']) ? $this->_data['is_auto'] : 0;
			$data['end_time'] = $endTime;
			$tmp[] = $data;
		}
		return $tmp;
	}

	/**
	 * ȡid
	 *
	 * @return int
	 */
	public function getTaskId() {
		return $this->id;
	}

	/**
	 * id
	 *
	 * @param int $id
	 */
	public function setTaskId($id) {
		$this->id = (int) $id;
		return $this;
	}

	/**
	 * ǷԶ
	 *
	 * @param int $isAuto
	 * @return PwTaskDm
	 */
	public function setIsAuto($isAuto) {
		$this->_data['is_auto'] = (int) $isAuto;
		return $this;
	}

	/**
	 * Ƿʾ
	 *
	 * @param int $isDisplayAll
	 * @return PwTaskDm
	 */
	public function setIsDisplayAll($isDisplayAll) {
		$this->_data['is_display_all'] = (int) $isDisplayAll;
		return $this;
	}

	/**
	 * ˳
	 *
	 * @param int $view_order
	 * @return PwTaskDm
	 */
	public function setViewOrder($view_order) {
		$this->_data['view_order'] = (int) $view_order;
		return $this;
	}

	/**
	 * Ƿ
	 *
	 * @param int $is_open
	 * @return PwTaskDm
	 */
	public function setIsOpen($is_open) {
		$this->_data['is_open'] = (int) $is_open;
		return $this;
	}

	/**
	 * Ŀʼʱ
	 *
	 * @param int $startTime
	 * @return PwTaskDm
	 */
	public function setStartTime($startTime) {
		$this->_data['start_time'] = $startTime;
		return $this;
	}

	/**
	 * Ľʱ
	 *
	 * @param int $endTime
	 * @return PwTaskDm
	 */
	public function setEndTime($endTime) {
		$this->_data['end_time'] = $endTime;
		return $this;
	}

	/**
	 * 
	 *
	 * @param int $period
	 * @return PwTaskDm
	 */
	public function setPeriod($period) {
		$this->_data['period'] = (int) $period;
		return $this;
	}

	/**
	 * ǰ
	 *
	 * @param int $id
	 * @return PwTaskDm
	 */
	public function setPreTask($id) {
		$this->_data['pre_task'] = (int) $id;
		return $this;
	}

	/**
	 * 
	 *
	 * @param string $title
	 * @return PwTaskDm
	 */
	public function setTitle($title) {
		$this->_data['title'] = trim($title);
		return $this;
	}

	/**
	 * 
	 *
	 * @param string $description
	 * @return PwTaskDm
	 */
	public function setDescription($description) {
		$this->_data['description'] = trim($description);
		return $this;
	}

	/**
	 * ͼ
	 *
	 * @param string $icon
	 * @return PwTaskDm
	 */
	public function setIcon($icon) {
		$this->_data['icon'] = trim($icon);
		return $this;
	}

	/**
	 * û
	 *
	 * @param array $userGroups
	 * @return PwTaskDm
	 */
	public function setUserGroups($userGroups) {
		$this->groups = (array) $userGroups;
		return $this;
	}

	/**
	 * Ľ
	 *
	 * @param string $reward
	 * @return PwTaskDm
	 */
	public function setReward($reward) {
		$this->_data['reward'] = $reward;
		return $this;
	}

	/**
	 * 
	 *
	 * @param array $conditions
	 * @return PwTaskDm
	 */
	public function setConditions($conditions) {
		$this->_data['conditions'] = $conditions;
		return $this;
	}

	/* (non-PHPdoc)
	 * @see PwBaseDm::_beforeAdd()
	 */
	protected function _beforeAdd() {
		if (empty($this->_data['title'])) return new PwError('TASK:title.empty');
		if (empty($this->_data['description'])) return new PwError('TASK:description.empty');
		if (!isset($this->_data['is_open'])) $this->_data['is_open'] = 0;
		$this->_data['user_groups'] = implode(',', $this->groups);
		if (isset($this->_data['end_time']))
			$this->_data['end_time'] = $this->_data['end_time'] ? $this->_data['end_time'] : self::MAXENDTIME;
		else
			$this->_data['end_time'] = self::MAXENDTIME;
		if (($r = $this->filterConditionData()) instanceof PwError) return $r;
		if (($r = $this->filterRewardData()) instanceof PwError) return $r;
		return true;
	}

	/* (non-PHPdoc)
	 * @see PwBaseDm::_beforeUpdate()
	 */
	protected function _beforeUpdate() {
		if (!$this->id) return new PwError('TASK:id.empty');
		if (empty($this->_data['title'])) return new PwError('TASK:title.empty');
		$this->_data['user_groups'] = implode(',', $this->groups);
		if (isset($this->_data['end_time']))
			$this->_data['end_time'] = $this->_data['end_time'] ? $this->_data['end_time'] : self::MAXENDTIME;
		else
			$this->_data['end_time'] = self::MAXENDTIME;
		if (($r = $this->filterConditionData()) instanceof PwError) return $r;
		if (($r = $this->filterRewardData()) instanceof PwError) return $r;
		return true;
	}

	/**
	 * 
	 * 
	 * 
	 * ݹurl: ȥӣ֧{tid}ռλʽ$conditionsеıȥ滻urlеռλ
	 *  url=bbs/thread/run?fid={fid},  conditionsһԪΪcondition['fid'] = 10;
	 * 򽫻url滻Ϊ: bbs/thread/run?fid=10;
	 * һrequire:Ϊkey=>msg(ΪյʱϢ
	 * ڽ
	 * ݹ"key": keyvalueжӦֵɣݹһdescriptռλִҲkeyжӦ
	 * key= typeid-name-unity  Ӧvalue= 1--
	 * descript={num}{unity}{name}  Ӧɣ 10  ---numڴݹֵ
	 */
	protected function filterConditionData() {
		if (!isset($this->_data['conditions'])) return true;
		$condition = $this->_data['conditions'];
		if (!$condition || !is_array($condition)) return new PwError('TASK:condition.require');
		//
		if (!$condition['child']) return new PwError('TASK:condition.require');
		$url = $condition['url'];
		unset($condition['url']);
		$this->_data['conditions']['url'] = $this->getReplace($condition, $url);
		$this->_data['conditions'] = serialize($this->_data['conditions']);
		return true;
	}
	
	/**
	 * 
	 * 
	 * ڽ
	 * ݹ"key": keyvalueжӦֵɣݹһdescriptռλִҲkeyжӦ
	 * key= typeid-name-unity  Ӧvalue= 1--
	 * descript={num}{unity}{name}  Ӧɣ 10  ---numڴݹֵ
	 */
	protected function filterRewardData() {
		if (!isset($this->_data['reward']) || !$this->decoration) {
			$this->_data['reward'] = serialize(array());
			return true;
		}
		if (!is_array($this->_data['reward'])) return new PwError('TASK:condition.reward.format.error');
		
		if ($this->decoration instanceof PwTaskRewardDoBase) {
			$reward = $this->decoration->checkReward($this->_data['reward']);
			if ($reward instanceof PwError) return $reward;
		}		
		$this->_data['reward'] = serialize($reward);
	}

	/**
	 * 滻ĵַ
	 *
	 * @param array $vars  滻
	 * @param string $string 滻ַ
	 * @return string 滻ַ
	 */
	protected function getReplace($vars, $string) {
		$search = array();
		foreach ($vars as $key => $val) {
			$search[] = '{' . $key . '}';
		}
		return str_replace($search, array_values($vars), $string);
	}
	
	/**
	 * ý
	 *
	 * @param PwTaskRewardDoBase $reward
	 * @return PwTaskDm
	 */
	public function setRewardDecoration(PwTaskRewardDoBase $reward) {
		$this->decoration = $reward;
		return $this;
	}
}
?>