<?php
Wind::import('SRV:task.dm.PwTaskUserDm');
/**
 * ȡBP
 * 
 * 
 * 1жϸǷܹǰû죺
 * 1-1Ƿѹ
 * 1-2ǷѾ
 * 1-3ûǷ񣨸
 * 1-4Ϊ񣬸ûɸ񣬵ǸǷѴﵽ´ʱ䡣
 * 1-5ǰ񣬸ǰǷѾɡ
 *
 * @author xiaoxia.xu <x_824@sina.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwTaskApply.php 11641 2012-06-11 09:26:41Z xiaoxia.xuxx $
 * @package src.service.task.srv
 */
class PwTaskApply {
	private $uid = null;
	private $gids = array();

	/**
	 * ʼ
	 *
	 * @param int $uid ûID
	 */
	public function __construct($uid) {
		$this->uid = $uid;
		/* @var $userService PwUserService */
		$userService = Wekit::load('user.srv.PwUserService');
		$this->gids = $userService->getGidsByUid($uid);
		/*gid-1ûЧ*/
		$this->gids[] = -1;
	}

	/**
	 * 
	 *
	 * @param int $taskId ID
	 * @return true|PwError
	 */
	public function apply($taskId) {
		if (null === $this->uid) return new PwError('TASK:request.illegal');
		if (1 > $taskId = intval($taskId)) return new PwError('TASK:id.illegal');
		$task = $this->_getTaskDs()->get($taskId);
		if (!$task) return new PwError('TASK:id.illegal');
		$canApplied = $this->allowTaskApplied($task);
		return (true !== $canApplied) ? $canApplied : $this->doApply($task);
	}

	/**
	 * Զӿ
	 *
	 * Զ֮󣬽ܳɹһIDµtask_cache
	 * 1ԶŵԶ֮pw_task_cache"
	 * 1-1񣺸task_idsɵԶIDб
	 * 
	 * @param array $taskIds
	 * @return boolean
	 */
	public function autoApplies($taskIds) {
		if (null === $this->uid) return false;
		$taskList = $this->_getTaskDs()->gets($taskIds);
		if (!$taskList) return new PwError('TASK:id.illegal');
		$cacheId = 0;
		$periodCache = array();
		/* @var $notice PwNoticeService */
		$notice = Wekit::load('message.srv.PwNoticeService');
		foreach ($taskList as $task) {
			if (true !== $this->allowTaskApplied($task)) continue;
			$cacheId = max($cacheId, $task['taskid']);
			$r = $this->doApply($task);
			if ($r instanceof PwError) continue;
			$notice->sendNotice($this->uid, 'task', $this->uid, $task);
			if ($task['period']) $periodCache[] = $task['taskid'];
		}
		$cache = $this->_getTaskDs()->getTaskCacheByUid($this->uid);
		if (!$cache) $cache = array(0, array());
		$cacheId && $cache[0] = $cacheId;
		$cache[1] = array_diff($cache[1], $periodCache);
		return $this->_getTaskDs()->updateUserTaskCache($this->uid, $cache);
	}

	/**
	 * һ
	 *
	 * @param array $task
	 * @return Ambigous <boolean, PwError>
	 */
	private function doApply($task) {
		$dm = new PwTaskUserDm();
		$dm->setTaskid($task['taskid'])->setUid($this->uid)->setTaskStatus(1)->setIsPeriod(
			$task['period'] > 0 ? 1 : 0)->setCreatedTime(Pw::getTime());
		$r = $this->_getTaskUserDs()->replaceUserTask($dm);
		if ($r instanceof PwError) return $r;
		return $this->_getTaskDs()->get($task['taskid']);
	}

	/**
	 * жǷ
	 *
	 * 1жϸǷܹǰû죺
	 * 1-1Ƿûй
	 * 1-2ǷѾ
	 * 1-3: ǷѾʼ
	 * 1-4ûûǷ
	 * 1-5ǰ񣬸ǰǷѾɡ
	 * 1-6ûǷ񣨸
	 * 1-7Ϊ񣬸ûǷɸ񣬲ҸǷѴﵽ´ʱ䡣
	 * 
	 * @param array $task Ϣ
	 * @return boolean|PwError
	 */
	private function allowTaskApplied($task) {
		$time = Pw::getTime();
		if ($task['end_time'] && ($task['end_time'] < $time)) {
			return new PwError('TASK:overtime');
		}
		if ($task['is_open'] == 0) {
			return new PwError('TASK:close');
		}
		if ($task['start_time'] && ($task['start_time'] > $time)) {
			return new PwError('TASK:no.open');
		}
		$gids = explode(',', $task['user_groups']);
		if (!array_intersect($gids, $this->gids)) {
			return new PwError('TASK:no.right');
		}
		/*ǰж*/
		if ($task['pre_task']) {
			$pre_taskApply = $this->_getTaskUserDs()->get($this->uid, $task['pre_task']);
			$pre_task = $this->_getTaskDs()->get($task['pre_task']);
			if (!$pre_taskApply) return new PwError('TASK:pre_task.require', 
				array('{title}' => $pre_task['title']));
			if (4 != $pre_taskApply['task_status']) return new PwError('TASK:pre_task.no.complete', 
				array('{title}' => $pre_task['title']));
		}
		/*ûб*/
		$taskApplied = $this->_getTaskUserDs()->get($this->uid, $task['taskid']);
		if (!$taskApplied) return true;
		/*Ѿ벢Ҹ*/
		if (intval($taskApplied['is_period']) === 0) {
			return new PwError('TASK:already.apply');
		}
		/*񣬵Ǹû*/
		if (4 != $taskApplied['task_status']) {
			return new PwError('TASK:already.apply.no.complete');
		}
		/*Ѿɣûдﵽ*/
		$periodTime = $task['period'] * 3600 + $taskApplied['finish_time'];
		if ($periodTime > Pw::getTime()) {
			return new PwError('TASK:apply.period.no.complete', 
				array('{time}' => Pw::time2str($periodTime, 'Y-m-d H:i:s')));
		}
		return true;
	}

	/**
	 * DS
	 * 
	 * @return PwTask
	 */
	private function _getTaskDs() {
		return Wekit::load('task.PwTask');
	}

	/**
	 * @return PwTaskUser
	 */
	private function _getTaskUserDs() {
		return Wekit::load('task.PwTaskUser');
	}
}