<?php
Wind::import('SRV:task.dm.PwTaskUserDm');
/**
 * BP
 *
 * @author xiaoxia.xu <x_824@sina.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwTaskComplete.php 9458 2012-05-07 07:56:42Z xiaoxia.xuxx $
 * @package src.service.task.srv
 */
class PwTaskComplete {
	private $num = 100;
	private $uid = 0;
	/* @var $doTask PwTaskCompleteInterface */
	private $doTask = null;

	/**
	 * 캯
	 *
	 * @param int $uid
	 * @param PwTaskCompleteInterface $doTask
	 */
	public function __construct($uid, PwTaskCompleteInterface $doTask) {
		$this->uid = intval($uid);
		$this->doTask = $doTask;
	}

	/**
	 * 
	 * 
	 * 1ѯǰûǷڽеûִ
	 * 2ʼ
	 * 3ûеϸϢ
	 * 4Ѿں͹رյЩ񶼲ٱ
	 * 5ִжϣжע-Ѿɵstepݸжconditionstepstepû¸step
	 * 
	 * @param string $type   ̨еġԱ/"̳࣬
	 * @param string $child еС࣬ 硱Ա->'˿'
	 * @return boolean
	 */
	public function doTask($type, $child) {
		if (!$this->doTask) return false;
		$myTasks = $this->_getTaskUserDs()->getMyTaskByStatus($this->uid, 1, $this->num, 0);
		if (!$myTasks) return true;
		$taskList = $this->_getTaskDs()->gets(array_keys($myTasks));
		if (!$taskList) return true;
		$time = Pw::getTime();
		foreach ($taskList as $id => $task) {
			if (($task['end_time'] && ($task['end_time'] < $time)) || ($task['is_open'] == 0)) {
				continue;
			}
			$conditions = unserialize($task['conditions']);
			if ($conditions['type'] != $type || $conditions['child'] != $child) continue;
			$myStatus = $myTasks[$id];
			$step = unserialize($myStatus['step']);
			if (!is_array($step)) $step = $myStatus['step'];
			$this->_doTask($task, $conditions, $step);
		}
		return true;
	}

	/**
	 * û
	 * 
	 * @param int $taskId
	 * @param array $conditions
	 * @param array $step
	 * @return boolean
	 */
	private function _doTask($taskInfo, $conditions, $step) {
		$result = $this->doTask->doTask($conditions, $step);
		if (!is_array($result) || !isset($result['isComplete']) || !isset($result['step'])) return false;
		$dm = new PwTaskUserDm();
		$dm->setTaskStatus($result['isComplete'] === true ? 2 : 1);
		if (true === $result['isComplete']) {
			/* @var $notice PwNoticeService */
			$notice = Wekit::load('message.srv.PwNoticeService');
			$taskInfo['complete'] = 1;
			$notice->sendNotice($this->uid, 'task', $this->uid, $taskInfo);
			is_array($result['step']) && $result['step']['percent'] = '100%';
		}
		$dm->setStep(is_array($result['step']) ? serialize($result['step']) : $result['step']);
		return $this->_getTaskUserDs()->update($taskInfo['taskid'], $this->uid, $dm);
	}

	/**
	 *  Ds
	 *
	 * @return PwTask
	 */
	private function _getTaskDs() {
		return Wekit::load('task.PwTask');
	}

	/**
	 * @return PwTaskUser
	 */
	private function _getTaskUserDs() {
		return Wekit::load('task.PwTaskUser');
	}
}