<?php
Wind::import('SRV:task.dm.PwTaskDmFactory');
/**
 * 
 *
 * @author xiaoxia.xu <x_824@sina.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwTaskService.php 24025 2013-01-21 03:18:31Z xiaoxia.xuxx $
 * @package src.service.task.srv
 */
class PwTaskService {
	/**
	 * ûΪݷԶ
	 *
	 * @param array $behavior
	 * @return boolean
	 */
	public function sendAutoTask($behavior) {
		if (!Wekit::C('site', 'task.isOpen')) return false;
		$whitBehavior = array('login_days', 'post_days', 'thread_count');
		if (!in_array($behavior['behavior'], $whitBehavior)) return false;
		$tody = Pw::time2str(Pw::getTime(), 'Y-m-d');
		$isSend = false;
		switch ($behavior['behavior']) {
			case 'login_days':
				$isSend = $behavior['number'] % 3 == 0;
				break;
			case 'post_days':
				$is_tody = ($tody == Pw::time2str($behavior['extend_info'], 'Y-m-d'));
				$isSend = $is_tody && $behavior['number'] % 2 == 0;
				break;
			case 'thread_count':
				$isSend = $behavior['number'] == 1 || $behavior['number'] % 50 == 0;
				break;
		}
		if (!$isSend) return false;
		Wind::import('SRV:task.srv.PwTaskApply');
		$userTask = new PwTaskApply($behavior['uid']);
		$userTask->autoApplies($this->getAutoApplicableTaskList($behavior['uid'], 1));
		return true;
	}

	/**
	 * һ
	 *
	 * @param int $id
	 * @param int $status 1ǹر0
	 * @param int $order ˳
	 * @param string $title 
	 * @return PwError|boolean
	 */
	public function openTask($id, $status, $order = '', $title = '') {
		$task = $this->_taskDs()->get($id);
		if (!$task) return new PwError('TASK:id.illegal');
		$taskDm = new PwTaskDm();
		$reward = unserialize($task['reward']);
		$taskDm->setTaskId($id)
			->setTitle($title)
			->setViewOrder($order)
			->setIsOpen($status)
			->setEndTime($task['end_time'])
			->setIsAuto($task['is_auto'])
			->setIsDisplayAll($task['is_display_all'])
			->setUserGroups(explode(',', $task['user_groups']))
			->setReward($reward);
		PwTaskDmFactory::addRewardDecoration($taskDm, $reward);
		return $this->_taskDs()->updateTask($taskDm);
	}

	/**
	 * ɾһ
	 * 1Ϣ
	 * 2-û ϵ
	 * 3-û ϵ
	 *
	 * @param int $id ID
	 * @return PwError|boolean
	 */
	public function deleteTask($id) {
		$task = $this->_taskDs()->get($id);
		if (!$task) return true;
		Pw::deleteAttach($task['icon']);
		$this->_taskUserDs()->delete($id);
		$r = $this->_taskDs()->deleteTask($id);
		if ($r instanceof PwError) return $r;
		return true;
	}

	/**
	 * ȡб
	 *
	 * @param int $page ѯҳ
	 * @param int $num  
	 * @return array
	 */
	public function getTaskList($page = 1, $num = 10) {
		$page = abs(intval($page));
		$num = abs(intval($num));
		$start = ($page - 1) * $num;
		$list = $this->_taskDs()->getTaskList($num, $start);
		$nextTask = $this->_taskDs()->fetchNextTaskList(array_keys($list));
		$lang = Wind::getComponent('i18n');
		$taskDb = array();
		foreach ($list as $k => $v) {
			$taskDb[$k] = array(
				'view_order' => $v['view_order'], 
				'title' => $v['title'], 
				'is_open' => $v['is_open'], 
				'reward' => unserialize($v['reward']), 
				'start_time' => $v['start_time'], 
				'end_time' => $v['end_time']);
			if (isset($nextTask[$k])) {
				$taskDb[$k]['msg'] = $lang->getMessage('TASK:delete.error.has.next.task', array('{title}' => $nextTask[$k]['title']));
			}
		}
		return $taskDb;
	}

	/**
	 * ȡûб
	 *
	 * 
	 * 1ûûȨ޵ģǸǶκûŵ
	 * 2ǵǰûûģû⡿)
	 * ʵ֣1ҳʵ
	 * 2״̬
	 * 2-1ǷѾ
	 * 2-2δ
	 * 2-3ǰʾ
	 * @param int $uid  ûID
	 * @param int $page ҳ
	 * @param int $num  
	 * @return array array(count, array())
	 */
	public function getApplicableTaskList($uid, $page = 1, $num = 10) {
		if (0 > ($uid = intval($uid))) return array(0, array());
		$gids = $this->_getGidsByUid($uid);
		$noPeriodTaskIds = $this->_taskUserDs()->getByIsPeriod($uid, 0);
		$page = abs(intval($page));
		$num = abs(intval($num));
		$start = ($page - 1) * $num;
		$count = $this->_taskDs()->countApplicableTasks(array_keys($noPeriodTaskIds), $gids, Pw::getTime());
		$taskIds = $this->_taskDs()->getApplicableTasks(array_keys($noPeriodTaskIds), $gids, $num, $start, Pw::getTime());
		return array($count, $this->_buildTaskList($this->_taskDs()->gets(array_keys($taskIds))));
	}

	/**
	 * ûڽеб
	 * 
	 * 
	 * 1ûɹ
	 * 2ûû콱
	 * ʵ֣
	 * 1ҳʵ
	 * 2״̬
	 * 2-1ǷѾڣڵ񲻿ɽнȥĲ
	 * 2-2ǷѾرգѾرյ񲻿ɽнȥĲ
	 * 2-3ǷѾɣ״̬ʾΪ콱
	 * ѹڣɣڽ
	 * 
	 * @param int $uid ûID
	 * @param int statu ûͣPwTask::DOING/UNREWARD/COMPLETEе
	 * @param int $page ҳ
	 * @param int $num 
	 * @return array array(count, array())
	 */
	public function getMyTaskListWithStatu($uid, $statu = PwTaskUser::COMPLETE, $page = 1, $num = 10) {
		if (0 > ($uid = intval($uid))) return array();
		$page = abs(intval($page));
		$num = abs(intval($num));
		$start = ($page - 1) * $num;
		$myTasks = $this->_taskUserDs()->getMyTaskByStatus($uid, $statu, $num, $start);
		$taskList = $this->_taskDs()->gets(array_keys($myTasks));
		return $this->_buildMyTaskList($taskList, $myTasks);
	}

	/**
	 * Զб
	 * 
	 * 1task_cacheлȡǰûһɵIDIDб
	 * 2Զ
	 * 3ûй
	 * 4ǰûûȨ
	 * 5ҸIDǵǰδԶСģ>һɵID limit 1) 
	 * 6IDб2-5ID+1õIDб
	 * ʵ֣
	 * 1͸û
	 * 2 ûִacceptTask
	 *
	 * @param int $uid ûID
	 * @param int $limit 
	 * @return array
	 */
	public function getAutoApplicableTaskList($uid, $limit = 1) {
		$cacheIds = $this->_taskDs()->getTaskCacheByUid($uid);
		$gids = $this->_getGidsByUid($uid);
		$ids = $this->_taskDs()->getAutoApplicableTask($cacheIds[0], $gids, abs(intval($limit)));
		$periods = isset($cacheIds[1]) ? (array) $cacheIds : array();
		return array_unique(array_keys($ids) + $periods);
	}

	/**
	 * Զ
	 * 
	 * @param int $taskid ID
	 * @param int $uid    ûID
	 * @return array
	 */
	public function getNextAutoApplicableTaskList($taskid, $uid) {
		$taskList = $this->_taskDs()->getNextAutoTasks($taskid, Pw::getTime(), Pw::getTime());
		$gids = $this->_getGidsByUid($uid);
		$taskIds = array();
		foreach ($taskList as $id => $task) {
			$_tmp = explode(',', $task['user_groups']);
			if (array_intersect($_tmp, $gids)) {
				$taskIds[] = $id;
			}
		}
		return $taskIds;
	}

	/**
	 * ȡһĿѡǰ
	 *
	 * @param int $taskid
	 * @return array
	 */
	public function getPreTasksByTaskId($taskid) {
		$tasks = $this->_taskDs()->getAll();
		Wind::import('SRV:task.srv.helper.PwTaskTreeHelper');
		$taskTree = PwTaskTreeHelper::getTaskTree($tasks);
		unset($tasks[$taskid]);
		if ($taskid) PwTaskTreeHelper::clearAllNextNode($taskTree[$taskid], $tasks, $taskid);
		return empty($tasks) ? array() : PwTaskTreeHelper::cookTree($taskTree['root']['items'], 
			array_keys($tasks));
	}

	/**
	 * ҵб
	 *
	 * ÿ״̬Ϣ
	 * 1-tag: Ͻʾ:1:ȡ2ѹرգ3ѽ4ڽУ5: ȡ--ɣ
	 * 2-continue: ťǷʹ
	 * 3-percent: еĽ
	 * 
	 * @param array $taskList Ϣ
	 * @param array $myTask ҵϢ
	 * @return array
	 */
	private function _buildMyTaskList($taskList, $myTask) {
		$time = Pw::getTime();
		foreach ($taskList as $id => &$task) {
			$task['tag'] = 1;
			$task['continue'] = true;
			if ($task['is_open'] == 0) {
				$task['tag'] = 2;
				$task['continue'] = false;
			} else {
				if ($task['end_time'] && ($task['end_time'] < $time)) {
					$task['tag'] = 3;
					$task['continue'] = false;
				} elseif (2 == $myTask[$id]['task_status']) {
					$task['tag'] = 5;
				}
			}
			/*if ($task['pre_task']) {
				$pre_task = $this->_taskDs()->get($task['pre_task']);
				$task['parent'] = $pre_task['title'];
			}*/
			$_tmp = unserialize($task['conditions']);
			$task['conditions'] = is_array($_tmp) ? $_tmp : array('url' => 'run');
			$_tmp = unserialize($task['reward']);
			$task['reward'] = is_array($_tmp) ? $_tmp : array('descript' => '');
			/*ɽȣstepбpercentԪ*/
			$step = unserialize($myTask[$id]['step']);
			$task['percent'] = is_array($step) && isset($step['percent']) ? $step['percent'] : '';
			/*нȲ״̬ΪȡıΪڽ*/
			if ($task['percent'] && $task['tag'] == 1) $task['tag'] = 4;
		}
		return $taskList;
	}

	/**
	 * б
	 * 
	 * ÿϢ
	 * 1-parent:ǰϢ
	 * 2-reward: 
	 * 
	 * @param array $taskList б
	 * @return array
	 */
	private function _buildTaskList($taskList) {
		$time = Pw::getTime();
		foreach ($taskList as $id => &$task) {
			/*if ($task['pre_task']) {
				$pre_task = $this->_taskDs()->get($task['pre_task']);
				$task['parent'] = $pre_task['title'];
			}*/
			$_tmp = unserialize($task['conditions']);
			$task['conditions'] = is_array($_tmp) ? $_tmp : array('url' => 'run');
			$_tmp = unserialize($task['reward']);
			$task['reward'] = is_array($_tmp) ? $_tmp : array('descript' => '');
		}
		return $taskList;
	}

	/**
	 * ûIDøûӵеûIDб
	 *
	 * @param int $uid ûID
	 * @param array $gids ûIDб
	 * @return array
	 */
	private function _getGidsByUid($uid) {
		/* @var $userService PwUserService */
		$userService = Wekit::load('user.srv.PwUserService');
		$gids = $userService->getGidsByUid($uid);
		/*gid-1ûЧ*/
		$gids[] = -1;
		return $gids;
	}

	/**
	 * DS
	 * 
	 * @return PwTask
	 */
	private function _taskDs() {
		return Wekit::load('task.PwTask');
	}

	/**
	 * ûds
	 *
	 * @return PwTaskUser
	 */
	private function _taskUserDs() {
		return Wekit::load('task.PwTaskUser');
	}
}