<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('SRV:user.dm.PwUserInfoDm');

/**
 * ûݽӿ
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwUser.php 24770 2013-02-20 11:22:38Z jieyin $
 * @package src.service.user
 */
class PwUser {
	
	const FETCH_MAIN = 1; //ȡûϢʺš
	const FETCH_DATA = 2; //ȡûݣ̳֡ͳϢ
	const FETCH_INFO = 4; //ȡû
	const FETCH_ALL = 7;

	const STATUS_UNCHECK = 1;//δ֤û
	const STATUS_UNACTIVE = 2;//δû
	const STATUS_BAN_AVATAR = 3;//ûֹͷ
	const STATUS_BAN_SIGN = 4;//ûֹǩ
	
	const STATUS_ALLOW_LOGIN_ADMIN = 5;//ûǷ̨Ȩ
	const STATUS_SIGN_USEUBB = 6;//ûǩǷʹUBB
	
	/** 
	 * ûIDûϢ
	 *
	 * @param int $uid 	ûID
	 * @param int $type Ϣ
	 * @return array
	 */
	public function getUserByUid($uid, $type = self::FETCH_MAIN) {
		if (empty($uid)) return array();
		return $this->_getDao($type)->getUserByUid($uid);
	}

	/** 
	 * ûֻûϢ
	 *
	 * @param string $username  û
	 * @param int $type   		Ϣ
	 * @return array
	 */
	public function getUserByName($username, $type = self::FETCH_MAIN) {
		if (empty($username)) return array();
		return $this->_getDao($type)->getUserByName($username);
	}
	
	/**
	 * ͨȡûϢ
	 *
	 * @param string $email 
	 * @param int $type ûϢ
	 * @return array
	 */
	public function getUserByEmail($email, $type = self::FETCH_MAIN) {
		if (empty($email)) return array();
		return $this->_getDao($type)->getUserByEmail($email);
	}
	
	/** 
	 * ûIDбȡûб
	 *
	 * @param array $uids ûб
	 * @param int $type
	 */
	public function fetchUserByUid($uids, $type = self::FETCH_MAIN) {//getUserListByUids($uids, $type = self::FETCH_MAIN) {
		if (empty($uids) || !is_array($uids)) return array();
		return $this->_getDao($type)->fetchUserByUid($uids);
	}
	
	/** 
	 * û
	 *
	 * @param array $names ûб
	 * @param int $type
	 * @return array
	 */
	public function fetchUserByName($names, $type = PwUser::FETCH_MAIN) {//getUserListByNames($names, $type = PwUser::FETCH_MAIN) {
		if (empty($names) || !is_array($names)) return array();
		return $this->_getDao($type)->fetchUserByName($names);
	}

	/** 
	 * ༭ûϢ
	 *
	 * @param PwUserInfoDm $dm ûϢDM
	 * @param int $type 	   
	 * @return boolean|PwError
	 */
	public function editUser(PwUserInfoDm $dm, $type = self::FETCH_ALL) {
		if (true !== ($result = $dm->beforeUpdate())) return $result;
		if (is_object($dm->dm)) {
			$result = $this->_getWindid()->editDmUser($dm->dm);
			if ($result < 1) return new PwError('WINDID:code.' . $result);
		}
		$result = $this->_getDao($type)->editUser($dm->uid, $dm->getData(), $dm->getIncreaseData(), $dm->getBitData());
		PwSimpleHook::getInstance('PwUser_update')->runDo($dm);
		return true;
	}
	
	/**
	 * û
	 *
	 * @param object $dm
	 * @return bool
	 */
	public function updateCredit(PwCreditDm $dm) {
		if (is_null($dm->dm)) return false;
		$result = $this->_getWindid()->editDmCredit($dm->dm);
		if ($result < 1) return new PwError('WINDID:code.' . $result);
		return $this->_getDao(self::FETCH_DATA)->editUser($dm->uid, $this->_getWindid()->getUserCredit($dm->uid));
	}

	/** 
	 * û
	 *
	 * @param PwUserInfoDm $dm ûϢDM
	 * @param int $type 	   ӱ
	 * @return int|PwError
	 */
	public function addUser(PwUserInfoDm $dm) {
		if (true !== ($result = $dm->beforeAdd())) return $result;
		if (($uid = $this->_getWindid()->addDmUser($dm->dm)) < 1) {
			return new PwError('WINDID:code.' . $uid);
		}
		$dm->setUid($uid);
		$this->_getDao(self::FETCH_ALL)->addUser($dm->getSetData());
		PwSimpleHook::getInstance('PwUser_add')->runDo($dm);
		return $uid;
	}
	
	/**
	 * û
	 *
	 * @param int $uid
	 * @return bool
	 */
	public function activeUser($uid) {
		if (!$data = $this->_getWindid()->getUser($uid, 1, PwUser::FETCH_ALL)) {
			return false;
		}
		$data['password'] = md5(WindUtility::generateRandStr(16));
		return $this->_getDao(self::FETCH_ALL)->addUser($data);
	}
	
	public function synEditUser($uid, $changepwd = 0) {
		if (!$data = $this->_getWindid()->getUser($uid, 1, PwUser::FETCH_ALL)) {
			return false;
		}
		$changepwd && $data['password'] = md5(WindUtility::generateRandStr(16));
		return $this->_getDao(self::FETCH_ALL)->editUser($uid, $data);
	}

	/** 
	 * ɾûϢ
	 *
	 * @param int $uid ûID
	 * @return boolean
	 */
	public function deleteUser($uid) {
		if (0 >= ($uid = intval($uid))) return new PwError('USER:illegal.id');
		$this->_getDao(self::FETCH_ALL)->deleteUser($uid);
		$this->_getWindid()->deleteUser($uid);
		PwSimpleHook::getInstance('PwUser_delete')->runDo($uid);
		return true;
	}
	
	/** 
	 * ûIDбɾûϢ
	 *
	 * @param array $uids ûIDб
	 * @return boolean
	 */
	public function batchDeleteUserByUid($uids) {
		if (empty($uids)) return false;
		$uids = (array)$uids;
		$this->_getDao(self::FETCH_ALL)->batchDeleteUser($uids);
		$this->_getWindid()->batchDeleteUser($uids);
		PwSimpleHook::getInstance('PwUser_batchDelete')->runDo($uids);
		return true;
	}
	
	/** 
	 * ûĶ
	 * 
	 * @return PwBaseDao
	 */
	protected function _getDao($type = self::FETCH_MAIN) {
		$daoMap = array();
		$daoMap[self::FETCH_MAIN] = 'user.dao.PwUserDao';
		$daoMap[self::FETCH_DATA] = 'user.dao.PwUserDataDao';
		$daoMap[self::FETCH_INFO] = 'user.dao.PwUserInfoDao';
		return Wekit::loadDaoFromMap($type, $daoMap, 'PwUser');
	}
	
	/** 
	 * windidDS
	 *
	 * @return WindidUser
	 */
	protected function _getWindid() {
		return Pw::windid('user');
	}
}